/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.oauth.models;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tds.common.annotation.Keep;
import com.tds.common.entities.AccessToken;
import java.util.Arrays;
import org.json.JSONException;

@Keep
public class AuthorizeResponse {
    public static final String KEY_RESPONSE = "com.taptap.sdk.response";
    public static final String RES_KEY_CANCEL = "com.taptap.sdk.response.cancel";
    public static final String RES_KEY_ERROR = "com.taptap.sdk.response.error";
    public static final String RES_KEY_TOKEN = "com.taptap.sdk.response.token";
    public static final String RES_KEY_CODE = "com.taptap.sdk.response.code";
    public static final String RES_KEY_CODE_VERIFIER = "com.taptap.sdk.response.codeVerifier";
    public static final String RES_KEY_LOGIN_VERSION = "com.taptap.sdk.response.login_version";
    public static final String RES_KEY_TOKEN_PARCELABLE = "com.taptap.sdk.response.token.parcel";
    public static final String RES_KEY_STATE = "com.taptap.sdk.response.state";
    public static final String RES_KEY_PERMISSIONS = "com.taptap.sdk.response.permissions";
    public String[] permissions;
    public String state;
    public String errorMessage;
    public AccessToken token;
    public boolean cancel;
    public String code;
    public String loginVersion;

    public AuthorizeResponse(String[] permissions, String state, String errorMessage, AccessToken token, boolean cancel) {
        this.permissions = permissions;
        this.state = state;
        this.errorMessage = errorMessage;
        this.token = token;
        this.cancel = cancel;
    }

    public Intent toIntent() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        intent.putExtra(KEY_RESPONSE, bundle);
        bundle.putBoolean(RES_KEY_CANCEL, this.cancel);
        bundle.putString(RES_KEY_TOKEN, this.token == null ? null : this.token.originalJson);
        bundle.putParcelable(RES_KEY_TOKEN_PARCELABLE, (Parcelable)this.token);
        bundle.putString(RES_KEY_ERROR, this.errorMessage);
        bundle.putString(RES_KEY_STATE, this.state);
        bundle.putString(RES_KEY_CODE, this.code);
        if (this.loginVersion != null) {
            bundle.putString(RES_KEY_LOGIN_VERSION, this.loginVersion);
        }
        bundle.putStringArray(RES_KEY_PERMISSIONS, this.permissions);
        return intent;
    }

    private AuthorizeResponse() {
    }

    public static AuthorizeResponse getResultFromIntent(Intent intent) throws JSONException {
        AuthorizeResponse result = new AuthorizeResponse();
        Bundle data = intent.getBundleExtra(KEY_RESPONSE);
        result.cancel = data.getBoolean(RES_KEY_CANCEL, false);
        String tokenJson = data.getString(RES_KEY_TOKEN);
        result.token = !TextUtils.isEmpty((CharSequence)tokenJson) ? new AccessToken(tokenJson) : (AccessToken)data.getParcelable(RES_KEY_TOKEN_PARCELABLE);
        result.errorMessage = data.getString(RES_KEY_ERROR);
        result.state = data.getString(RES_KEY_STATE);
        result.permissions = data.getStringArray(RES_KEY_PERMISSIONS);
        result.code = data.getString(RES_KEY_CODE);
        result.loginVersion = data.getString(RES_KEY_LOGIN_VERSION, "0");
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (null != this.permissions) {
            builder.append("\"permissions\"=").append(Arrays.toString(this.permissions)).append(" ");
        }
        builder.append("\"state\"=").append(this.state).append(" ");
        builder.append("\"errorMessage\"=").append(this.errorMessage).append(" ");
        builder.append("\"token\"=").append(this.token).append(" ");
        builder.append("\"cancel\"").append(this.cancel).append(" ");
        builder.append("\"code\"").append(this.cancel).append(" ");
        return builder.toString();
    }
}

