/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.internal.observers;

import com.tds.common.reactor.Observer;
import com.tds.common.reactor.exceptions.Exceptions;
import com.tds.common.reactor.exceptions.OnErrorThrowable;
import com.tds.common.reactor.operators.NotificationLite;

public class SerializedObserver<T>
implements Observer<T> {
    private final Observer<? super T> actual;
    private boolean emitting;
    private volatile boolean terminated;
    private FastList queue;

    public SerializedObserver(Observer<? super T> s) {
        this.actual = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void onNext(T t) {
        if (this.terminated) {
            return;
        }
        Object[] objectArray = this;
        // MONITORENTER : this
        if (this.terminated) {
            // MONITOREXIT : objectArray
            return;
        }
        if (this.emitting) {
            FastList list = this.queue;
            if (list == null) {
                this.queue = list = new FastList();
            }
            list.add(NotificationLite.next(t));
            // MONITOREXIT : objectArray
            return;
        }
        this.emitting = true;
        // MONITOREXIT : objectArray
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            this.terminated = true;
            Exceptions.throwOrReport(e, this.actual, t);
            return;
        }
        block8: while (true) {
            Object[] objectArray2 = this;
            // MONITORENTER : this
            FastList list = this.queue;
            if (list == null) {
                this.emitting = false;
                // MONITOREXIT : objectArray2
                return;
            }
            this.queue = null;
            // MONITOREXIT : objectArray2
            objectArray2 = list.array;
            int n = objectArray2.length;
            int n2 = 0;
            while (true) {
                Object o;
                if (n2 >= n || (o = objectArray2[n2]) == null) continue block8;
                try {
                    if (NotificationLite.accept(this.actual, o)) {
                        this.terminated = true;
                        return;
                    }
                }
                catch (Throwable e) {
                    this.terminated = true;
                    Exceptions.throwIfFatal(e);
                    this.actual.onError(OnErrorThrowable.addValueAsLastCause(e, t));
                    return;
                }
                ++n2;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        Exceptions.throwIfFatal(e);
        if (this.terminated) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                FastList list = this.queue;
                if (list == null) {
                    this.queue = list = new FastList();
                }
                list.add(NotificationLite.error(e));
                return;
            }
            this.emitting = true;
        }
        this.actual.onError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        if (this.terminated) {
            return;
        }
        SerializedObserver serializedObserver = this;
        synchronized (serializedObserver) {
            if (this.terminated) {
                return;
            }
            this.terminated = true;
            if (this.emitting) {
                FastList list = this.queue;
                if (list == null) {
                    this.queue = list = new FastList();
                }
                list.add(NotificationLite.completed());
                return;
            }
            this.emitting = true;
        }
        this.actual.onCompleted();
    }

    static final class FastList {
        Object[] array;
        int size;

        FastList() {
        }

        public void add(Object o) {
            int s = this.size;
            Object[] a = this.array;
            if (a == null) {
                this.array = a = new Object[16];
            } else if (s == a.length) {
                Object[] array2 = new Object[s + (s >> 2)];
                System.arraycopy(a, 0, array2, 0, s);
                this.array = a = array2;
            }
            a[s] = o;
            this.size = s + 1;
        }
    }
}

