/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.schedulers;

import com.tds.common.reactor.Subscription;
import com.tds.common.reactor.functions.Action0;
import com.tds.common.reactor.internal.schedulers.NewThreadWorker;
import com.tds.common.reactor.schedulers.Scheduler;
import com.tds.common.reactor.schedulers.SchedulerLifecycle;
import com.tds.common.reactor.subscriptions.Subscriptions;
import com.tds.common.reactor.util.RxThreadFactory;
import com.tds.common.reactor.util.SubscriptionList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class EventLoopsScheduler
extends Scheduler
implements SchedulerLifecycle {
    static final String KEY_MAX_THREADS = "rx.scheduler.max-computation-threads";
    static final int MAX_THREADS;
    static final PoolWorker SHUTDOWN_WORKER;
    static final FixedSchedulerPool NONE;
    final ThreadFactory threadFactory;
    final AtomicReference<FixedSchedulerPool> pool;

    public EventLoopsScheduler(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.pool = new AtomicReference<FixedSchedulerPool>(NONE);
        this.start();
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new EventLoopWorker(this.pool.get().getEventLoop());
    }

    @Override
    public void start() {
        FixedSchedulerPool update = new FixedSchedulerPool(this.threadFactory, MAX_THREADS);
        if (!this.pool.compareAndSet(NONE, update)) {
            update.shutdown();
        }
    }

    @Override
    public void shutdown() {
        FixedSchedulerPool curr;
        do {
            if ((curr = this.pool.get()) != NONE) continue;
            return;
        } while (!this.pool.compareAndSet(curr, NONE));
        curr.shutdown();
    }

    public Subscription scheduleDirect(Action0 action) {
        PoolWorker pw = this.pool.get().getEventLoop();
        return pw.scheduleActual(action, -1L, TimeUnit.NANOSECONDS);
    }

    static {
        int maxThreads = Integer.getInteger(KEY_MAX_THREADS, 0);
        int cpuCount = Runtime.getRuntime().availableProcessors();
        int max = maxThreads <= 0 || maxThreads > cpuCount ? cpuCount : maxThreads;
        MAX_THREADS = max;
        SHUTDOWN_WORKER = new PoolWorker(RxThreadFactory.NONE);
        SHUTDOWN_WORKER.unsubscribe();
        NONE = new FixedSchedulerPool(null, 0);
    }

    static final class PoolWorker
    extends NewThreadWorker {
        PoolWorker(ThreadFactory threadFactory) {
            super(threadFactory);
        }
    }

    static final class EventLoopWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial = new SubscriptionList();
        private final SubscriptionList both = new SubscriptionList((Subscription)this.serial);
        private final PoolWorker poolWorker;

        EventLoopWorker(PoolWorker poolWorker) {
            this.poolWorker = poolWorker;
        }

        @Override
        public void unsubscribe() {
            this.both.unsubscribe();
        }

        @Override
        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }

        @Override
        public Subscription schedule(final Action0 action) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            return this.poolWorker.scheduleActual(new Action0(){

                @Override
                public void call() {
                    if (EventLoopWorker.this.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                }
            }, 0L, null, this.serial);
        }

        @Override
        public Subscription schedule(final Action0 action, long delayTime, TimeUnit unit) {
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            return this.poolWorker.scheduleActual(new Action0(){

                @Override
                public void call() {
                    if (EventLoopWorker.this.isUnsubscribed()) {
                        return;
                    }
                    action.call();
                }
            }, delayTime, unit);
        }
    }

    static final class FixedSchedulerPool {
        final int cores;
        final PoolWorker[] eventLoops;
        long n;

        FixedSchedulerPool(ThreadFactory threadFactory, int maxThreads) {
            this.cores = maxThreads;
            this.eventLoops = new PoolWorker[maxThreads];
            for (int i = 0; i < maxThreads; ++i) {
                this.eventLoops[i] = new PoolWorker(threadFactory);
            }
        }

        public PoolWorker getEventLoop() {
            int c = this.cores;
            if (c == 0) {
                return SHUTDOWN_WORKER;
            }
            return this.eventLoops[(int)(this.n++ % (long)c)];
        }

        public void shutdown() {
            for (PoolWorker w : this.eventLoops) {
                w.unsubscribe();
            }
        }
    }
}

