/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.region;

import android.content.Context;
import android.content.SharedPreferences;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.tds.common.net.ResponseBean;
import com.tds.common.net.TdsApiClient;
import com.tds.common.net.TdsHttp;
import com.tds.common.net.XUAParams;
import com.tds.common.net.intercerptor.AddXUAInterceptor;
import com.tds.common.net.json.TypeRef;
import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.functions.Func1;
import com.tds.common.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tds.common.reactor.schedulers.Schedulers;
import com.tds.common.region.RegionBean;
import com.tds.common.utils.Validate;
import java.util.HashMap;
import java.util.Locale;

public class TdsRegionHelper {
    private static final String RegionKey = "tds_region_key";
    private static final String RegionStore = "tds_region_store";

    public static void getRegionCode(final Context context, final RegionCallback callback) {
        Validate.notNull(callback, "callback cannot be null");
        int regionCode = TdsRegionHelper.getLocalRegion(context);
        if (regionCode != -1) {
            callback.onRegion(regionCode == 1);
            return;
        }
        final int operatorInfo = TdsRegionHelper.getOperatorInfo(context);
        TdsRegionHelper.getRemoteRegion(operatorInfo, context.getPackageName()).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(new Subscriber<RegionBean>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                TdsRegionHelper.doLocalJudge(context, callback, operatorInfo);
            }

            @Override
            public void onNext(RegionBean regionBean) {
                if (regionBean != null && regionBean.regionCode != -1) {
                    TdsRegionHelper.setLocalRegion(context, regionBean.regionCode);
                    callback.onRegion(regionBean.regionCode == 1);
                } else {
                    TdsRegionHelper.doLocalJudge(context, callback, operatorInfo);
                }
            }
        });
    }

    public static int getOperatorInfo(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        int info = 0;
        if (telephonyManager != null) {
            String NetworkOperator = telephonyManager.getNetworkOperator();
            Log.i((String)"TdsRegionHelper", (String)("NetworkOperator=" + NetworkOperator));
            if (NetworkOperator != null && (NetworkOperator.startsWith("460") || NetworkOperator.startsWith("461"))) {
                info = 1;
            }
            return info;
        }
        return 0;
    }

    private static Observable<RegionBean> getRemoteRegion(int carrier, String packageName) {
        TdsHttp.Client client = TdsHttp.newClientBuilder().addInterceptor(new AddXUAInterceptor(XUAParams.getCommonXUAParams("TdsCommon", 31605001, "3.16.5"))).build();
        TdsApiClient tdsApiClient = new TdsApiClient.Builder().baseUrl("https://tds.taptap-api.com/tool/check_ip_region").tdsClient(client).build();
        HashMap<String, String> queries = new HashMap<String, String>();
        queries.put("carrier", "" + carrier);
        queries.put("bundle", packageName);
        return tdsApiClient.getAsync(new TypeRef<ResponseBean<RegionBean>>(){}, "", queries).map(new Func1<ResponseBean<RegionBean>, RegionBean>(){

            @Override
            public RegionBean call(ResponseBean<RegionBean> response) {
                return (RegionBean)response.data;
            }
        });
    }

    private static void doLocalJudge(Context context, RegionCallback callback, int operatorInfo) {
        boolean isMainlandChina = TdsRegionHelper.isChinaOperator(operatorInfo) || TdsRegionHelper.isLocaleChina();
        TdsRegionHelper.setLocalRegion(context, isMainlandChina ? 1 : 0);
        callback.onRegion(isMainlandChina);
    }

    private static int getLocalRegion(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(RegionStore, 0);
        return sharedPreferences.getInt(RegionKey, -1);
    }

    private static void setLocalRegion(Context context, int region) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(RegionStore, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(RegionKey, region);
        editor.apply();
    }

    private static boolean isChinaOperator(int operator) {
        return operator == 1;
    }

    private static boolean isLocaleChina() {
        return Locale.getDefault().getCountry().toLowerCase().contains("cn");
    }

    public static interface RegionCallback {
        public void onRegion(boolean var1);
    }
}

