/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.tds.common.tracker.constants.TrackerType;
import com.tds.common.utils.DeviceUtils;
import com.tds.common.utils.GUIDHelper;
import com.tds.common.utils.NetworkUtil;
import java.util.HashMap;
import java.util.Map;

public class TdsTrackerConfig
implements Parcelable {
    private static final int DEFAULT_GROUP_SIZE = 5;
    public final String project;
    public final String endPoint;
    public final String logStore;
    public final String accessKeyId;
    public final String accessKeySecret;
    public final int groupSize;
    public final String topic;
    public final Map<String, String> tagsMap;
    public final String sdkVersionCode;
    public final String sdkVersionName;
    public final String platform;
    public final String osVersion;
    public final String androidId;
    public final String appVersion;
    public final String cachePath;
    public final String appPackageName;
    public final String ramSize;
    public final String romSize;
    public final String networkType;
    public final String mobileType;
    public static final Parcelable.Creator<TdsTrackerConfig> CREATOR = new Parcelable.Creator<TdsTrackerConfig>(){

        public TdsTrackerConfig createFromParcel(Parcel in) {
            return new TdsTrackerConfig(in);
        }

        public TdsTrackerConfig[] newArray(int size) {
            return new TdsTrackerConfig[size];
        }
    };

    private TdsTrackerConfig() {
        this.project = "";
        this.endPoint = "";
        this.logStore = "";
        this.accessKeyId = "";
        this.accessKeySecret = "";
        this.groupSize = 0;
        this.topic = "";
        this.tagsMap = new HashMap<String, String>();
        this.sdkVersionCode = "";
        this.sdkVersionName = "";
        this.platform = "";
        this.osVersion = "";
        this.androidId = "";
        this.appVersion = "";
        this.cachePath = "";
        this.appPackageName = "";
        this.ramSize = "";
        this.romSize = "";
        this.networkType = "";
        this.mobileType = "";
    }

    public TdsTrackerConfig(Builder builder) {
        this.project = builder.project;
        this.endPoint = builder.endPoint;
        this.logStore = builder.logStore;
        this.accessKeyId = builder.accessKeyId;
        this.accessKeySecret = builder.accessKeySecret;
        this.groupSize = builder.groupSize;
        this.topic = TrackerType.getTrackerName(builder.trackerType);
        this.tagsMap = new HashMap<String, String>();
        this.tagsMap.put("PLATFORM", DeviceUtils.getPlatform());
        this.sdkVersionName = !TextUtils.isEmpty((CharSequence)builder.sdkVersionName) ? builder.sdkVersionName : "";
        this.sdkVersionCode = builder.sdkVersionCode != -1 ? String.valueOf(builder.sdkVersionCode) : "";
        this.platform = DeviceUtils.getPlatform();
        this.osVersion = DeviceUtils.getOSVersion();
        this.androidId = builder.androidId;
        this.appVersion = builder.appVersion;
        this.cachePath = builder.cachePath;
        this.appPackageName = builder.appPackageName;
        this.ramSize = builder.ramSize;
        this.romSize = builder.romSize;
        this.networkType = builder.networkType;
        this.mobileType = builder.mobileType;
    }

    protected TdsTrackerConfig(Parcel in) {
        this.project = in.readString();
        this.endPoint = in.readString();
        this.logStore = in.readString();
        this.accessKeyId = in.readString();
        this.accessKeySecret = in.readString();
        this.groupSize = in.readInt();
        this.topic = in.readString();
        this.tagsMap = new HashMap<String, String>();
        in.readMap(this.tagsMap, this.getClass().getClassLoader());
        this.sdkVersionCode = in.readString();
        this.sdkVersionName = in.readString();
        this.platform = in.readString();
        this.osVersion = in.readString();
        this.androidId = in.readString();
        this.appVersion = in.readString();
        this.cachePath = in.readString();
        this.appPackageName = in.readString();
        this.ramSize = in.readString();
        this.romSize = in.readString();
        this.networkType = in.readString();
        this.mobileType = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.project);
        dest.writeString(this.endPoint);
        dest.writeString(this.logStore);
        dest.writeString(this.accessKeyId);
        dest.writeString(this.accessKeySecret);
        dest.writeInt(this.groupSize);
        dest.writeString(this.topic);
        dest.writeMap(this.tagsMap);
        dest.writeString(this.sdkVersionCode);
        dest.writeString(this.sdkVersionName);
        dest.writeString(this.platform);
        dest.writeString(this.osVersion);
        dest.writeString(this.androidId);
        dest.writeString(this.appVersion);
        dest.writeString(this.cachePath);
        dest.writeString(this.appPackageName);
        dest.writeString(this.ramSize);
        dest.writeString(this.romSize);
        dest.writeString(this.networkType);
        dest.writeString(this.mobileType);
    }

    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private String project;
        private String endPoint;
        private String logStore;
        private String accessKeyId;
        private String accessKeySecret;
        private int groupSize = 5;
        private int trackerType;
        private int sdkVersionCode = -1;
        private String sdkVersionName = "";
        private String androidId;
        private String appVersion;
        private String cachePath;
        private String appPackageName;
        private String ramSize;
        private String romSize;
        private String networkType;
        private String mobileType;

        public Builder withTrackerType(int trackerType) {
            this.trackerType = trackerType;
            return this;
        }

        public Builder withAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder withAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder withProjectName(String project) {
            this.project = project;
            return this;
        }

        public Builder withEndPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public Builder withLogStore(String logStore) {
            this.logStore = logStore;
            return this;
        }

        public Builder withGroupSize(int size) {
            this.groupSize = size;
            return this;
        }

        public Builder withSdkVersion(int sdkVersionCode) {
            this.sdkVersionCode = sdkVersionCode;
            return this;
        }

        public Builder withSdkVersionName(String sdkVersionName) {
            this.sdkVersionName = sdkVersionName;
            return this;
        }

        public TdsTrackerConfig build(Context context) {
            String lackRequiredParameterName = "";
            if (context != null) {
                GUIDHelper.INSTANCE.init(context.getApplicationContext());
            }
            if (TextUtils.isEmpty((CharSequence)this.accessKeyId)) {
                lackRequiredParameterName = "accessKeyId";
            } else if (TextUtils.isEmpty((CharSequence)this.accessKeySecret)) {
                lackRequiredParameterName = "accessKeySecret";
            } else if (TextUtils.isEmpty((CharSequence)this.project)) {
                lackRequiredParameterName = "project";
            } else if (TextUtils.isEmpty((CharSequence)this.endPoint)) {
                lackRequiredParameterName = "endPoint";
            } else if (TextUtils.isEmpty((CharSequence)this.logStore)) {
                lackRequiredParameterName = "logStore";
            }
            if (context != null && !TextUtils.isEmpty((CharSequence)lackRequiredParameterName)) {
                throw new RuntimeException("lack of parameter [" + lackRequiredParameterName + "]");
            }
            if (context != null) {
                this.androidId = DeviceUtils.getAndroidId(context);
            }
            if (context != null) {
                this.appVersion = DeviceUtils.getPackageVersion(context);
            }
            if (context != null) {
                this.cachePath = context.getFilesDir() + "/" + TrackerType.getTrackerName(this.trackerType);
            }
            if (context != null) {
                this.appPackageName = context.getPackageName();
            }
            if (context != null) {
                this.ramSize = DeviceUtils.getRemainingRamSize(context);
            }
            if (context != null) {
                this.romSize = DeviceUtils.getRemainingRomSize();
            }
            if (context != null) {
                this.networkType = NetworkUtil.getConnectedType(context);
            }
            if (context != null) {
                this.mobileType = NetworkUtil.getNetworkType(context);
            }
            return new TdsTrackerConfig(this);
        }
    }
}

