/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker.model;

import android.text.TextUtils;
import com.tds.common.tracker.annotations.Login;
import com.tds.common.tracker.exceptions.ModelConvertException;
import com.tds.common.tracker.model.BaseTrackModel;
import java.util.HashMap;
import java.util.Map;

public class LoginModel
implements BaseTrackModel {
    public static final String PARAM_LOGIN_SESSION_ID = "login_session_id";
    public static final String PARAM_LOGIN_ACTION = "login_action";
    public static final String PARAM_LOGIN_TYPE = "login_type";
    public static final String PARAM_LOGIN_ERROR_CODE = "login_error_code";
    public static final String PARAM_LOGIN_ERROR_MSG = "login_error_msg";
    private String loginSessionId = "";
    private String loginAction = "";
    private String loginType = "";
    private String loginErrorCode = "";
    private String loginErrorMsg = "";

    public LoginModel withLoginSessionId(String sessionId) {
        this.loginSessionId = sessionId;
        return this;
    }

    public LoginModel withLoginAction(@Login.StringLoginActionType String action) {
        this.loginAction = action;
        return this;
    }

    public LoginModel withLoginType(@Login.StringLoginType String loginType) {
        this.loginType = loginType;
        return this;
    }

    public LoginModel withLoginErrorCode(String errorCode) {
        this.loginErrorCode = errorCode;
        return this;
    }

    public LoginModel withLoginErrorMsg(String errorMsg) {
        this.loginErrorMsg = errorMsg;
        return this;
    }

    @Override
    public Map<String, String> convert() throws Exception {
        if (TextUtils.isEmpty((CharSequence)this.loginSessionId)) {
            throw new ModelConvertException("login model param session_id empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.loginAction)) {
            throw new ModelConvertException("login model param login_action empty");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PARAM_LOGIN_SESSION_ID, this.loginSessionId);
        result.put(PARAM_LOGIN_ACTION, this.loginAction);
        if (!TextUtils.isEmpty((CharSequence)this.loginType)) {
            result.put(PARAM_LOGIN_TYPE, this.loginType);
        }
        if (!TextUtils.isEmpty((CharSequence)this.loginErrorCode)) {
            result.put(PARAM_LOGIN_ERROR_CODE, this.loginErrorCode);
        }
        if (!TextUtils.isEmpty((CharSequence)this.loginErrorMsg)) {
            result.put(PARAM_LOGIN_ERROR_MSG, this.loginErrorMsg);
        }
        return result;
    }
}

