/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SP {
    private static Map<String, SP> mSPCache = new ConcurrentHashMap<String, SP>();
    private static Context sContext;
    private SharedPreferences mSp;

    private SP(String name) {
        this.mSp = sContext.getApplicationContext().getSharedPreferences(name, 0);
    }

    public static boolean inited() {
        return sContext != null;
    }

    public static synchronized void initialize(Context context) {
        sContext = context.getApplicationContext();
    }

    public static SP getSP(String name) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("sp name empty");
        }
        if (mSPCache.containsKey(name)) {
            return mSPCache.get(name);
        }
        SP sp = new SP(name);
        mSPCache.put(name, sp);
        return sp;
    }

    public String getString(String key, String defValue) {
        return this.mSp.getString(key, defValue);
    }

    public Set<String> getStringSet(String key, Set<String> defValues) {
        return this.mSp.getStringSet(key, defValues);
    }

    public int getInt(String key, int defValue) {
        return this.mSp.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return this.mSp.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return this.mSp.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.mSp.getBoolean(key, defValue);
    }

    public boolean contains(String key) {
        return this.mSp.contains(key);
    }

    public void putString(String key, String value) {
        this.mSp.edit().putString(key, value).apply();
    }

    public void putStringSet(String key, Set<String> values) {
        this.mSp.edit().putStringSet(key, values).apply();
    }

    public void putInt(String key, int value) {
        this.mSp.edit().putInt(key, value).apply();
    }

    public void putLong(String key, long value) {
        this.mSp.edit().putLong(key, value).apply();
    }

    public void putFloat(String key, float value) {
        this.mSp.edit().putFloat(key, value).apply();
    }

    public void putBoolean(String key, boolean value) {
        this.mSp.edit().putBoolean(key, value).apply();
    }

    public void remove(String key) {
        this.mSp.edit().remove(key).apply();
    }

    public void clear() {
        this.mSp.edit().clear().apply();
    }
}

