/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;

public class TapGameUtil {
    private static final String TAG = TapGameUtil.class.getName();
    public static final String PACKAGE_NAME_TAPTAP = "com.taptap";
    public static final String PACKAGE_NAME_TAPTAP_GLOBAL = "com.taptap.global";
    public static final String CLIENT_URI_TAPTAP = "taptap://taptap.com";
    public static final String CLIENT_URI_TAPTAP_GLOBAL = "tapglobal://taptap.tw";
    public static final String DEFAULT_CLIENT_DOWNLOAD_URL_TAPTAP = "https://l.taptap.com/5d1NGyET";
    public static final String DEFAULT_CLIENT_DOWNLOAD_URL_TAPTAP_GLOBAL = "https://l.taptap.io/GNYwFaZr";

    public static boolean updateGameAndFailToWebInTapTap(Activity activity, String appId) {
        return TapGameUtil.updateGameInTapTap(activity, appId) || TapGameUtil.openWebDownloadUrlOfTapTap(activity, appId);
    }

    public static boolean updateGameAndFailToWebInTapGlobal(Activity activity, String appId) {
        return TapGameUtil.updateGameInTapGlobal(activity, appId) || TapGameUtil.openWebDownloadUrlOfTapGlobal(activity, appId);
    }

    public static boolean updateGameAndFailToWebInTapTap(Activity activity, String appId, String webUrl) {
        if (TextUtils.isEmpty((CharSequence)webUrl)) {
            return TapGameUtil.updateGameAndFailToWebInTapTap(activity, appId);
        }
        return TapGameUtil.updateGameInTapTap(activity, appId) || TapGameUtil.openWebDownloadUrl(activity, webUrl);
    }

    public static boolean updateGameAndFailToWebInTapGlobal(Activity activity, String appId, String webUrl) {
        if (TextUtils.isEmpty((CharSequence)webUrl)) {
            return TapGameUtil.updateGameAndFailToWebInTapGlobal(activity, appId);
        }
        return TapGameUtil.updateGameInTapGlobal(activity, appId) || TapGameUtil.openWebDownloadUrl(activity, webUrl);
    }

    public static boolean isTapTapInstalled(Context context) {
        return TapGameUtil.isTapClientInstalled(context, PACKAGE_NAME_TAPTAP);
    }

    public static boolean isTapGlobalInstalled(Context context) {
        return TapGameUtil.isTapClientInstalled(context, PACKAGE_NAME_TAPTAP_GLOBAL);
    }

    public static boolean isTapClientInstalled(Context context, String clientPackageName) {
        if (context != null && !TextUtils.isEmpty((CharSequence)clientPackageName)) {
            boolean TapTapInstalled = false;
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(clientPackageName, 0);
                if (null != packageInfo) {
                    TapTapInstalled = true;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)(clientPackageName + " isInstalled=false"));
            }
            return TapTapInstalled;
        }
        return false;
    }

    public static boolean updateGameInTapTap(Activity activity, String appId) {
        return TapGameUtil.updateGameInTapClient(activity, appId, CLIENT_URI_TAPTAP);
    }

    public static boolean updateGameInTapGlobal(Activity activity, String appId) {
        return TapGameUtil.updateGameInTapClient(activity, appId, CLIENT_URI_TAPTAP_GLOBAL);
    }

    public static boolean updateGameInTapClient(Activity activity, String appId, String clientUri) {
        if (activity != null && !TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)clientUri)) {
            try {
                Uri uri = Uri.parse((String)String.format(Locale.US, "%s/app?app_id=%s&source=outer|update", clientUri, appId));
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setFlags(0x10000000);
                activity.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)(clientUri + "updateGameInTapTap failed"));
                return false;
            }
            return true;
        }
        Log.e((String)TAG, (String)(clientUri + "updateGameInTapTap failed"));
        return false;
    }

    public static boolean openReviewInTapTap(Activity activity, String appId) {
        return TapGameUtil.openReviewInTapClient(activity, appId, CLIENT_URI_TAPTAP);
    }

    public static boolean openReviewInTapGlobal(Activity activity, String appId) {
        return TapGameUtil.openReviewInTapClient(activity, appId, CLIENT_URI_TAPTAP_GLOBAL);
    }

    public static boolean openReviewInTapClient(Activity activity, String appId, String clientUri) {
        if (activity != null && !TextUtils.isEmpty((CharSequence)appId) && !TextUtils.isEmpty((CharSequence)clientUri)) {
            try {
                Uri uri = Uri.parse((String)String.format(Locale.US, "%s/app?tab_name=review&app_id=%s", clientUri, appId));
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setFlags(0x10000000);
                activity.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)(clientUri + "openTapTapReview failed"));
                return false;
            }
            return true;
        }
        Log.e((String)TAG, (String)(clientUri + "openTapTapReview failed"));
        return false;
    }

    public static boolean openWebDownloadUrlOfTapTap(Activity activity, String appId) {
        return TapGameUtil.openWebDownloadUrl(activity, String.format(Locale.US, "https://l.taptap.com/5d1NGyET?subc1=%s", appId));
    }

    public static boolean openWebDownloadUrlOfTapGlobal(Activity activity, String appId) {
        return TapGameUtil.openWebDownloadUrl(activity, String.format(Locale.US, "https://l.taptap.io/GNYwFaZr?subc1=%s", appId));
    }

    public static boolean openWebDownloadUrl(Activity activity, String url) {
        if (activity != null && !TextUtils.isEmpty((CharSequence)url)) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setFlags(0x10000000);
                intent.setData(Uri.parse((String)url));
                activity.startActivity(intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"openWebUrl fail");
                return false;
            }
            return true;
        }
        return false;
    }
}

