/*
 * Decompiled with CFR 0.152.
 */
package tds.androidx.core.view;

import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsController;
import android.view.inputmethod.InputMethodManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.Nullable;
import tds.androidx.annotation.RequiresApi;
import tds.androidx.annotation.RestrictTo;

public final class WindowInsetsControllerCompat {
    public static final int BEHAVIOR_SHOW_BARS_BY_TOUCH = 0;
    public static final int BEHAVIOR_SHOW_BARS_BY_SWIPE = 1;
    public static final int BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE = 2;
    private final Impl mImpl;

    @RequiresApi(value=30)
    private WindowInsetsControllerCompat(@NonNull WindowInsetsController insetsController) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(insetsController) : new Impl();
    }

    public WindowInsetsControllerCompat(@NonNull Window window, @NonNull View view) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(window) : (Build.VERSION.SDK_INT >= 26 ? new Impl26(window, view) : (Build.VERSION.SDK_INT >= 23 ? new Impl23(window, view) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(window, view) : new Impl())));
    }

    @NonNull
    @RequiresApi(value=30)
    public static WindowInsetsControllerCompat toWindowInsetsControllerCompat(@NonNull WindowInsetsController insetsController) {
        return new WindowInsetsControllerCompat(insetsController);
    }

    public void show(int types) {
        this.mImpl.show(types);
    }

    public void hide(int types) {
        this.mImpl.hide(types);
    }

    public boolean isAppearanceLightStatusBars() {
        return this.mImpl.isAppearanceLightStatusBars();
    }

    public void setAppearanceLightStatusBars(boolean isLight) {
        this.mImpl.setAppearanceLightStatusBars(isLight);
    }

    public boolean isAppearanceLightNavigationBars() {
        return this.mImpl.isAppearanceLightNavigationBars();
    }

    public void setAppearanceLightNavigationBars(boolean isLight) {
        this.mImpl.setAppearanceLightNavigationBars(isLight);
    }

    public void setSystemBarsBehavior(int behavior) {
        this.mImpl.setSystemBarsBehavior(behavior);
    }

    public int getSystemBarsBehavior() {
        return this.mImpl.getSystemBarsBehavior();
    }

    @RequiresApi(value=30)
    private static class Impl30
    extends Impl {
        private final WindowInsetsController mInsetsController;

        Impl30(Window window) {
            this.mInsetsController = window.getInsetsController();
        }

        Impl30(WindowInsetsController insetsController) {
            this.mInsetsController = insetsController;
        }

        @Override
        void show(int types) {
            this.mInsetsController.show(types);
        }

        @Override
        void hide(int types) {
            this.mInsetsController.hide(types);
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            return (this.mInsetsController.getSystemBarsAppearance() & 8) != 0;
        }

        @Override
        public void setAppearanceLightStatusBars(boolean isLight) {
            if (isLight) {
                this.mInsetsController.setSystemBarsAppearance(8, 8);
            } else {
                this.mInsetsController.setSystemBarsAppearance(0, 8);
            }
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            return (this.mInsetsController.getSystemBarsAppearance() & 0x10) != 0;
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean isLight) {
            if (isLight) {
                this.mInsetsController.setSystemBarsAppearance(16, 16);
            } else {
                this.mInsetsController.setSystemBarsAppearance(0, 16);
            }
        }

        @Override
        void setSystemBarsBehavior(int behavior) {
            this.mInsetsController.setSystemBarsBehavior(behavior);
        }

        @Override
        int getSystemBarsBehavior() {
            return this.mInsetsController.getSystemBarsBehavior();
        }
    }

    @RequiresApi(value=26)
    private static class Impl26
    extends Impl23 {
        Impl26(@NonNull Window window, @Nullable View view) {
            super(window, view);
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            return (this.mWindow.getDecorView().getSystemUiVisibility() & 0x10) != 0;
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean isLight) {
            if (isLight) {
                this.unsetWindowFlag(0x8000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(16);
            } else {
                this.unsetSystemUiFlag(16);
            }
        }
    }

    @RequiresApi(value=23)
    private static class Impl23
    extends Impl20 {
        Impl23(@NonNull Window window, @Nullable View view) {
            super(window, view);
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            return (this.mWindow.getDecorView().getSystemUiVisibility() & 0x2000) != 0;
        }

        @Override
        public void setAppearanceLightStatusBars(boolean isLight) {
            if (isLight) {
                this.unsetWindowFlag(0x4000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(8192);
            } else {
                this.unsetSystemUiFlag(8192);
            }
        }
    }

    @RequiresApi(value=20)
    private static class Impl20
    extends Impl {
        @NonNull
        protected final Window mWindow;
        @Nullable
        private final View mView;

        Impl20(@NonNull Window window, @Nullable View view) {
            this.mWindow = window;
            this.mView = view;
        }

        @Override
        void show(int typeMask) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.showForType(i);
            }
        }

        private void showForType(int type) {
            switch (type) {
                case 1: {
                    this.unsetSystemUiFlag(4);
                    this.unsetWindowFlag(1024);
                    return;
                }
                case 2: {
                    this.unsetSystemUiFlag(2);
                    return;
                }
                case 8: {
                    View view = this.mView;
                    if (view != null && (view.isInEditMode() || view.onCheckIsTextEditor())) {
                        view.requestFocus();
                    } else {
                        view = this.mWindow.getCurrentFocus();
                    }
                    if (view == null) {
                        view = this.mWindow.findViewById(0x1020002);
                    }
                    if (view == null || !view.hasWindowFocus()) break;
                    final View finalView = view;
                    finalView.post(new Runnable(){

                        @Override
                        public void run() {
                            InputMethodManager imm = (InputMethodManager)finalView.getContext().getSystemService("input_method");
                            imm.showSoftInput(finalView, 0);
                        }
                    });
                }
            }
        }

        @Override
        void hide(int typeMask) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.hideForType(i);
            }
        }

        private void hideForType(int type) {
            switch (type) {
                case 1: {
                    this.setSystemUiFlag(4);
                    this.setWindowFlag(1024);
                    return;
                }
                case 2: {
                    this.setSystemUiFlag(2);
                    return;
                }
                case 8: {
                    ((InputMethodManager)this.mWindow.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mWindow.getDecorView().getWindowToken(), 0);
                }
            }
        }

        protected void setSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | systemUiFlag);
        }

        protected void unsetSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & ~systemUiFlag);
        }

        protected void setWindowFlag(int windowFlag) {
            this.mWindow.addFlags(windowFlag);
        }

        protected void unsetWindowFlag(int windowFlag) {
            this.mWindow.clearFlags(windowFlag);
        }

        @Override
        void setSystemBarsBehavior(int behavior) {
        }

        @Override
        int getSystemBarsBehavior() {
            return 0;
        }
    }

    private static class Impl {
        Impl() {
        }

        void show(int types) {
        }

        void hide(int types) {
        }

        void setSystemBarsBehavior(int behavior) {
        }

        int getSystemBarsBehavior() {
            return 0;
        }

        public boolean isAppearanceLightStatusBars() {
            return false;
        }

        public void setAppearanceLightStatusBars(boolean isLight) {
        }

        public boolean isAppearanceLightNavigationBars() {
            return false;
        }

        public void setAppearanceLightNavigationBars(boolean isLight) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static @interface Behavior {
    }
}

