/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.activity;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.m3839.sdk.common.CommonMananger;
import com.m3839.sdk.common.activity.ActivityStackManager;

public abstract class BaseActivity
extends Activity {
    public void onCreate(Bundle bundle) {
        this.setRequestedOrientation(CommonMananger.getInstance().getOrientation());
        super.onCreate(bundle);
        ActivityStackManager.getInstance().addActivity(this);
        if (CommonMananger.getInstance().getOrientation() == 0) {
            BaseActivity baseActivity = this;
            baseActivity.setContentView(baseActivity.getLandLayoutId());
        } else {
            BaseActivity baseActivity = this;
            baseActivity.setContentView(baseActivity.getPortLayoutId());
        }
    }

    public abstract int getPortLayoutId();

    public abstract int getLandLayoutId();

    public void onDestroy() {
        BaseActivity baseActivity = this;
        ActivityStackManager.getInstance().finishActivity(this);
        baseActivity.releaseViewEvent(baseActivity.getWindow().getDecorView());
        super.onDestroy();
    }

    public void releaseViewEvent(View view) {
        if (view instanceof ViewGroup) {
            view = (ViewGroup)view;
            for (int i2 = 0; i2 < view.getChildCount(); ++i2) {
                View view2 = view.getChildAt(i2);
                view2.setOnClickListener(null);
                this.releaseViewEvent(view2);
            }
        }
    }
}

