/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.CountDownTimer;
import android.text.TextUtils;
import com.sdk.douyou.Constant;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.activity.DouYouLoginMoreNoticecActivity;
import com.sdk.douyou.activity.DouYouNoticeContentActivity;
import com.sdk.douyou.activity.DouYouSwitchRealNameActivity;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.dialog.DouYouJumpInfoDialog;
import com.sdk.douyou.fun.DouYouGroMore;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.ResourceUtil;
import com.sdk.douyou.util.SpUtil;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;
import com.sdk.douyou.util.view.TipDialog;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class DouYouManage {
    private static DouYouManage instance;
    CountDownTimer countDownTimer;

    public static DouYouManage getInstance() {
        if (instance == null) {
            instance = new DouYouManage();
        }
        return instance;
    }

    public void homeBefore() {
        if (Constant.openAD) {
            try {
                DouYouGroMore.getInstance().closeGroMoreAD();
            }
            catch (Exception e) {
                LogUtil.debug("\u805a\u5408\u5e7f\u544a \u95ee\u9898\u53ef\u5ffd\u7565");
            }
        }
        Constant.is_register = false;
        Constant.isLogin = false;
        DouYou.getInstance().hideFloatBall();
        DouYou.getInstance().loginSuccessBean = null;
        DouYou.getInstance().gameHomeCallback.home();
    }

    public void enterBefore() {
        Constant.isLogin = true;
        DouYou.getInstance().showFloatBall((Context)DouYou.getInstance().context);
        if (DouYou.getInstance().getOrders().size() > 0) {
            OrderInfoBean orderInfoBean = DouYou.getInstance().getOrders().get(0);
            DouYou.getInstance().CheckOrder(orderInfoBean);
        }
        SpUtil.getInstance().putInt("user_login_time", 1);
        LogUtil.debug("\u767b\u5f55\u6210\u529f\u901a\u77e5\u7814\u53d1 \uff1a " + DouYou.getInstance().loginSuccessBean.getMembers_id() + " : " + DouYou.getInstance().loginSuccessBean.getToken());
        DouYou.getInstance().gameCallback.enter(DouYou.getInstance().loginSuccessBean.getMembers_id(), DouYou.getInstance().loginSuccessBean.getToken());
        this.getLoginNotice();
        this.showBingPhone();
        this.AntiAddiction();
    }

    private void AntiAddiction() {
        try {
            BaLeApi.getInstance().AntiAddiction(new DouYouPostAsyncTask.HttpGetDataListener(){

                @Override
                public void getData(String returnData) {
                    try {
                        JSONObject jsonObject = new JSONObject(returnData);
                        Constant.douyou_antiaddiction_show_tip = jsonObject.optInt("show_tips", 0);
                        if (Constant.douyou_antiaddiction_show_tip == 1) {
                            Constant.douyou_antiaddiction_show_msg = jsonObject.optString("show_msg", "");
                            DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouSwitchRealNameActivity.class));
                            DouYou.getInstance().executorService.schedule(new Runnable(){

                                @Override
                                public void run() {
                                    DouYouManage.this.AntiAddiction();
                                }
                            }, 300L, TimeUnit.SECONDS);
                        } else if (Constant.douyou_antiaddiction_show_tip == 2) {
                            Constant.douyou_antiaddiction_show_msg = jsonObject.optString("show_msg", "");
                            DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouSwitchRealNameActivity.class));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void Fail(String error) {
                    LogUtil.debug(error);
                }
            });
        }
        catch (Exception e) {
            LogUtil.debug("Error in AntiAddiction method:" + e);
        }
    }

    private void showBingPhone() {
        if (DouYou.getInstance().loginSuccessBean.getIs_bind_phone() != 0) {
            DouYou.getInstance().showFloatFuncBindPhone((Context)DouYou.getInstance().context);
        }
    }

    public void register() {
        Constant.is_register = true;
        DouYou.getInstance().onResult(39, "\u6ce8\u518c\u6210\u529f");
    }

    public void pollingCheckOrder(final OrderInfoBean orderInfoBean) {
        int times = 0;
        switch (orderInfoBean.getCheckTimes()) {
            case 3: {
                times = 1000;
                break;
            }
            case 2: {
                times = 30000;
                break;
            }
            case 1: {
                times = 30000;
            }
        }
        this.countDownTimer = new CountDownTimer(times, 1000L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                DouYouManage.this.countDownTimer.cancel();
                DouYou.getInstance().CheckOrder(orderInfoBean);
            }
        };
        this.countDownTimer.start();
    }

    public void checkOrder(final OrderInfoBean orderInfoBean) {
        LogUtil.debug("\u6821\u9a8c\u8ba2\u5355 : " + orderInfoBean.toString());
        final String orderID = orderInfoBean.getXxx();
        if (DouYou.getInstance().loginSuccessBean != null) {
            BaLeApi.getInstance().checkOrder(orderID, new DouYouPostAsyncTask.HttpGetDataListener(){

                @Override
                public void getData(String returnData) {
                    try {
                        JSONObject jsonObject = new JSONObject(returnData);
                        int is_pay = jsonObject.optInt("state", 0);
                        if (is_pay == 2) {
                            DouYou.getInstance().onPayResult(10, orderInfoBean);
                            DouYouManage.this.getPayNotice();
                            DouYou.getInstance().removeOrderById(orderID);
                            if (DouYou.getInstance().getOrders().size() > 0) {
                                OrderInfoBean orderInfoBean2 = DouYou.getInstance().getOrders().get(0);
                                DouYou.getInstance().CheckOrder(orderInfoBean2);
                            }
                        } else {
                            int value = orderInfoBean.getCheckTimes() - 1;
                            if (value > 0) {
                                orderInfoBean.setCheckTimes(value);
                                DouYou.getInstance().setOrders(orderInfoBean);
                                DouYouManage.this.pollingCheckOrder(orderInfoBean);
                            } else {
                                DouYou.getInstance().onPayResult(11, orderInfoBean);
                                DouYou.getInstance().removeOrderById(orderID);
                                if (DouYou.getInstance().getOrders().size() > 0) {
                                    OrderInfoBean orderInfoBean3 = DouYou.getInstance().getOrders().get(0);
                                    DouYou.getInstance().CheckOrder(orderInfoBean3);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogUtil.debug("\u8ba2\u5355\u67e5\u8be2\u5f02\u5e38");
                    }
                }

                @Override
                public void Fail(String error) {
                    LogUtil.debug(error);
                    if ("\u627e\u4e0d\u5230\u8be5\u8ba2\u5355".equals(error)) {
                        DouYou.getInstance().removeOrderById(orderID);
                    }
                }
            });
        }
    }

    public void ballGetUserInfo() {
        BaLeApi.getInstance().membersInfo(new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                try {
                    JSONObject jsonObject = new JSONObject(returnData);
                    JSONObject member_info = new JSONObject(jsonObject.optString("member_info"));
                    Constant.user_info_phone = member_info.optString("mobile", "");
                    Constant.user_info_idname = member_info.optString("true_name", "");
                    Constant.user_info_idcard = member_info.optString("id_card", "");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void Fail(String error) {
                LogUtil.debug(error);
            }
        });
    }

    public void showMissingPermissionDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)DouYou.getInstance().context);
        builder.setTitle((CharSequence)"\u5e2e\u52a9");
        builder.setMessage((CharSequence)"\u5f53\u524d\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u6743\u9650\u3002\u8bf7\u70b9\u51fb\"\u8bbe\u7f6e\"-\"\u6743\u9650\"-\u6253\u5f00\u6240\u9700\u6743\u9650\u3002\u6700\u540e\u70b9\u51fb\u4e24\u6b21\u540e\u9000\u6309\u94ae\uff0c\u5373\u53ef\u8fd4\u56de");
        builder.setNegativeButton((CharSequence)"\u9000\u51fa", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DouYou.getInstance().context.finish();
                System.exit(1);
            }
        });
        builder.setPositiveButton((CharSequence)"\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DouYou.getInstance().toSetpremission = true;
                DouYouManage.this.startAppSettings();
            }
        });
        builder.setCancelable(false);
        builder.show();
    }

    private void startAppSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.setData(Uri.parse((String)("package:" + DouYou.getInstance().context.getPackageName())));
        DouYou.getInstance().context.startActivity(intent);
    }

    public void showNormalDialog(Context context, String msg) {
        TipDialog dialog = new TipDialog(context, msg);
        dialog.show();
    }

    public void getLoginNotice() {
        BaLeApi.getInstance().LoginNotice(DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                try {
                    JSONObject objdata = new JSONObject(returnData);
                    Constant.douyou_more_notice_msg = objdata.optString("notice_list");
                    if (!TextUtils.isEmpty((CharSequence)Constant.douyou_more_notice_msg) && Constant.douyou_more_notice_msg.length() > 5) {
                        DouYou.getInstance().context.startActivity(new Intent((Context)DouYou.getInstance().context, DouYouLoginMoreNoticecActivity.class));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void Fail(String error) {
                LogUtil.debug(error);
            }
        });
    }

    public void getPayNotice() {
        BaLeApi.getInstance().PayNotice(new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                try {
                    LogUtil.debug(returnData);
                    JSONObject objdata = new JSONObject(returnData);
                    JSONObject notice = new JSONObject(objdata.optString("notice"));
                    Constant.douyou_notice_title = notice.optString("title", "");
                    Constant.douyou_notice_content = notice.optString("notice_url", "");
                    Constant.douyou_notice_id = notice.optString("notice_id", "");
                    if (!TextUtils.isEmpty((CharSequence)Constant.douyou_notice_title) && Constant.douyou_notice_title.length() > 5) {
                        Intent intent = new Intent((Context)DouYou.getInstance().context, DouYouNoticeContentActivity.class);
                        intent.putExtra("url", Constant.douyou_notice_content);
                        DouYou.getInstance().context.startActivity(intent);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void Fail(String error) {
                LogUtil.debug(error);
            }
        });
    }

    public void JustContactSetvice() {
        try {
            LogUtil.debug("DouYouManage-\u8df3\u8f6c\u5ba2\u670d\u5730\u5740:" + Constant.kf_link);
            Intent intent = Intent.parseUri((String)Constant.kf_link, (int)1);
            DouYou.getInstance().context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jumpInfo(final Activity activity) {
        BaLeApi.getInstance().jumpInfo(new DouYouPostAsyncTask.HttpGetDataListener(){

            @Override
            public void getData(String returnData) {
                try {
                    LogUtil.debug(returnData);
                    JSONObject jumpInfo_obj = new JSONObject(returnData);
                    Constant.douyou_jumpInfo_show = jumpInfo_obj.optInt("is_show", 0);
                    Constant.douyou_jumpInfo_img_url = jumpInfo_obj.optString("img_url", "");
                    Constant.douyou_jumpInfo_jump_url = jumpInfo_obj.optString("jump_url", "");
                    if (!TextUtils.isEmpty((CharSequence)Constant.douyou_jumpInfo_img_url) && Constant.douyou_jumpInfo_show == 1) {
                        new DouYouJumpInfoDialog((Context)activity, ResourceUtil.getStyleId((Context)DouYou.getInstance().context, "CustomDialog")).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void Fail(String error) {
                LogUtil.debug(error);
            }
        });
    }
}

