/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util;

import android.app.ActivityManager;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.AssetManager;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.activity.DouYouAgreementActivity;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.List;

public class DouYouSDKTools {
    public static final String ENCODING = "UTF-8";

    public static String getMetaData(Context ctx, String key) {
        try {
            ApplicationInfo appInfo = ctx.getPackageManager().getApplicationInfo(ctx.getPackageName(), 128);
            if (appInfo != null && appInfo.metaData != null && appInfo.metaData.containsKey(key)) {
                return "" + appInfo.metaData.get(key);
            }
            Log.e((String)"DouYouSDK", (String)("The meta-data key is not exists." + key));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void copy(Context context, String s, String tip) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText(null, (CharSequence)s);
        clipboard.setPrimaryClip(clipData);
        Toast.makeText((Context)context, (CharSequence)("\u62f7\u8d1d\u6210\u529f," + tip + " : " + s), (int)1).show();
    }

    public static String getCopy(Context context) {
        ClipboardManager clipboard = (ClipboardManager)context.getSystemService("clipboard");
        ClipData clipData = clipboard.getPrimaryClip();
        if (clipData != null && clipData.getItemCount() > 0) {
            return clipData.getItemAt(0).getText().toString();
        }
        return null;
    }

    public static boolean isServiceRunning(Context mContext, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)mContext.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(30);
        if (serviceList.size() <= 0) {
            return false;
        }
        LogUtil.debug("OnlineService \uff1a" + className);
        for (int i = 0; i < serviceList.size(); ++i) {
            if (!((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName().contains(className)) continue;
            isRunning = true;
            break;
        }
        return isRunning;
    }

    public static void openApp(String packageName) {
        PackageInfo pi = null;
        try {
            pi = DouYou.getInstance().context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Intent resolveIntent = new Intent("android.intent.action.MAIN", null);
        resolveIntent.addCategory("android.intent.category.LAUNCHER");
        resolveIntent.setPackage(pi.packageName);
        List apps = DouYou.getInstance().context.getPackageManager().queryIntentActivities(resolveIntent, 0);
        ResolveInfo ri = (ResolveInfo)apps.iterator().next();
        if (ri != null) {
            packageName = ri.activityInfo.packageName;
            String className = ri.activityInfo.name;
            Intent intent = new Intent("android.intent.action.MAIN");
            intent.addCategory("android.intent.category.LAUNCHER");
            ComponentName cn = new ComponentName(packageName, className);
            intent.setComponent(cn);
            DouYou.getInstance().context.startActivity(intent);
        }
    }

    public static boolean isFileExists(Context context, String filename) {
        AssetManager assets = context.getAssets();
        try {
            String[] list = assets.list("");
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].equals(filename.trim())) continue;
                Log.e((String)"DouYou", (String)(filename + "\u5b58\u5728"));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"DouYou", (String)(filename + "\u4e0d\u5b58\u5728"));
            return false;
        }
        Log.e((String)"DouYou", (String)(filename + "\u4e0d\u5b58\u5728"));
        return false;
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return false;
        }
        NetworkInfo[] info = connectivity.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED && info[i].getState() != NetworkInfo.State.CONNECTING) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getAppOps(Context context) {
        try {
            Class[] arrayOfClass;
            Object object = context.getSystemService("appops");
            if (object == null) {
                return false;
            }
            Class<?> localClass = object.getClass();
            Method method = localClass.getMethod("checkOp", arrayOfClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class});
            if (method == null) {
                return false;
            }
            Object[] arrayOfObject1 = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            int m = (Integer)method.invoke(object, arrayOfObject1);
            return m == 0;
        }
        catch (Exception ex) {
            LogUtil.debug("\u60ac\u6d6e\u7a97\u68c0\u6d4b");
            return false;
        }
    }

    public static String getFromAsset(Context context, String fileName) {
        String result = context.getResources().getString(ResourceUtil.getStringId(context, "douyou_agreement_content"));
        if (DouYouSDKTools.isFileExists(context, fileName)) {
            try {
                InputStream in = context.getResources().getAssets().open(fileName);
                int length = in.available();
                byte[] buffer = new byte[length];
                in.read(buffer);
                result = new String(buffer, ENCODING);
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void showAgreement(final Context context, TextView textView, String content) {
        SpannableString spannableString = new SpannableString((CharSequence)content);
        int index = content.lastIndexOf("\u300a\u7528\u6237\u534f\u8bae\u300b");
        int lastIndex = content.lastIndexOf("\u300a\u9690\u79c1\u653f\u7b56\u300b");
        ClickableSpan userSpan = new ClickableSpan(){

            public void onClick(View view) {
                Intent userintent = new Intent(context, DouYouAgreementActivity.class);
                userintent.putExtra("agreement", "https://api.aargame.com//web/Agreement/user/Id/" + DouYou.getInstance().getAd(context) + ".html");
                context.startActivity(userintent);
            }

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
            }
        };
        ClickableSpan privateSpan = new ClickableSpan(){

            public void onClick(View view) {
                Intent userintent = new Intent(context, DouYouAgreementActivity.class);
                userintent.putExtra("agreement", "https://api.aargame.com//web/Agreement/privacy/Id/" + DouYou.getInstance().getAd(context) + ".html");
                context.startActivity(userintent);
            }

            public void updateDrawState(TextPaint ds) {
                ds.setUnderlineText(false);
            }
        };
        spannableString.setSpan((Object)userSpan, index, index + 6, 0);
        spannableString.setSpan((Object)privateSpan, lastIndex, lastIndex + 6, 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#d4716b")), index, index + 6, 0);
        spannableString.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#d4716b")), lastIndex, lastIndex + 6, 0);
        textView.setText((CharSequence)spannableString);
        textView.setHighlightColor(0);
        textView.setMovementMethod(ScrollingMovementMethod.getInstance());
        textView.setMovementMethod(LinkMovementMethod.getInstance());
    }
}

