/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import android.annotation.SuppressLint;
import com.bytedance.applog.log.LogInfoBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class LogInfo {
    private static final ThreadLocal<SimpleDateFormat> threadLocalDateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        @SuppressLint(value={"SimpleDateFormat"})
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private String appId;
    private String thread;
    private int level = 1;
    private int category = 0;
    private List<String> tags;
    private String message;
    private long time = System.currentTimeMillis();
    private Throwable throwable;

    public static LogInfoBuilder builder() {
        return new LogInfoBuilder();
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String getLevelString() {
        switch (this.level) {
            case 0: {
                return "VERBOSE";
            }
            case 1: {
                return "DEBUG";
            }
            case 2: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 4: {
                return "ERROR";
            }
            case 5: {
                return "ASSERT";
            }
        }
        return "";
    }

    public String getCategoryString() {
        switch (this.category) {
            case 1: {
                return "DEVICE_REGISTER";
            }
            case 2: {
                return "ABTEST";
            }
            case 3: {
                return "ALINK";
            }
            case 4: {
                return "EVENT";
            }
            case 5: {
                return "DATABASE";
            }
            case 6: {
                return "EVENT_VERIFY";
            }
            case 8: {
                return "MONITOR";
            }
            case 10: {
                return "PICKER";
            }
            case 7: {
                return "VIEW_EXPOSURE";
            }
            case 9: {
                return "USER_PROFILE";
            }
            case 11: {
                return "REQUEST";
            }
            case 12: {
                return "EVENT_SAMPLING";
            }
            case 13: {
                return "EVENT_PRIORITY";
            }
            case 14: {
                return "COMPRESS";
            }
            case 15: {
                return "ONE_ID";
            }
        }
        return "DEFAULT";
    }

    public String getTagString() {
        if (null != this.tags && this.tags.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.tags.size(); ++i) {
                stringBuilder.append(this.tags.get(i));
                if (i >= this.tags.size() - 1) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public String getTimeString() {
        if (this.time > 0L) {
            return threadLocalDateFormat.get().format(new Date(this.time));
        }
        return "--";
    }

    public String toString() {
        String toMessage = "[" + this.getTimeString() + "][" + this.getLevelString() + "][" + this.toString(this.appId) + "][" + this.toString(this.thread) + "][" + this.getCategoryString() + "][" + this.getTagString() + "] " + this.toString(this.message);
        if (null != this.getThrowable()) {
            toMessage = toMessage + "\nstacktrace: " + this.getExceptionStackString(this.getThrowable());
        }
        return toMessage;
    }

    public String toLiteString() {
        return "[" + this.getLevelString() + "][" + this.toString(this.appId) + "] " + this.toString(this.message);
    }

    public String toMessage() {
        return this.toString(this.message);
    }

    private String toString(Object obj) {
        return null != obj ? obj.toString() : "";
    }

    private String getExceptionStackString(Throwable e) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Throwable cause = e; null != cause; cause = cause.getCause()) {
            this.appendStackString(stringBuilder, cause);
        }
        return stringBuilder.toString();
    }

    private void appendStackString(StringBuilder sb, Throwable cause) {
        StackTraceElement[] trace;
        sb.append(cause.toString());
        for (StackTraceElement traceElement : trace = cause.getStackTrace()) {
            sb.append("\n\tat ").append(traceElement);
        }
    }

    public static class Category {
        public static final int DEFAULT = 0;
        public static final int DEVICE_REGISTER = 1;
        public static final int ABTEST = 2;
        public static final int ALINK = 3;
        public static final int EVENT = 4;
        public static final int DATABASE = 5;
        public static final int EVENT_VERIFY = 6;
        public static final int VIEW_EXPOSURE = 7;
        public static final int MONITOR = 8;
        public static final int USER_PROFILE = 9;
        public static final int PICKER = 10;
        public static final int REQUEST = 11;
        public static final int EVENT_SAMPLING = 12;
        public static final int EVENT_PRIORITY = 13;
        public static final int COMPRESS = 14;
        public static final int ONE_ID = 15;
    }

    public static class Level {
        public static final int VERBOSE = 0;
        public static final int DEBUG = 1;
        public static final int INFO = 2;
        public static final int WARNING = 3;
        public static final int ERROR = 4;
        public static final int ASSERT = 5;
    }
}

