/*
 * Decompiled with CFR 0.152.
 */
package com.m3839.sdk.common.view.richtext;

import android.graphics.Color;
import android.text.Editable;
import android.text.Html;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import android.util.Log;
import android.view.View;
import com.m3839.sdk.common.view.richtext.HtmlTagHelper;
import java.util.Stack;
import org.xml.sax.XMLReader;

public class HtmlTagHandler
implements Html.TagHandler {
    private static final String TAG = "HtmlTagHandler";
    private static final String HTML_TAG_SPAN = "span";
    private static final String HTML_TAG_A = "ajump";
    private static final String CSS_NAME_COLOR = "color";
    private static final String CSS_NAME_FONT_SIZE = "font-size";
    private Stack<Integer> indexStack;
    private OnTextClickListener onTextClickListener;

    public HtmlTagHandler(OnTextClickListener onTextClickListener) {
        Stack stack;
        Stack stack2 = stack;
        stack = new Stack();
        v1.indexStack = stack2;
        v1.onTextClickListener = onTextClickListener;
    }

    private void handleStartTag(String string2, Editable editable, XMLReader xMLReader) {
        String string3 = string2.toLowerCase();
        string3.hashCode();
        if (!string3.equals(HTML_TAG_SPAN)) {
            if (string3.equals(HTML_TAG_A)) {
                this.aStartTag(string2, editable, xMLReader);
            }
        } else {
            this.spanStartTag(string2, editable, xMLReader);
        }
    }

    private void handleEndTag(int n, int n2, String string2, Editable editable, XMLReader xMLReader) {
        String string3 = string2.toLowerCase();
        string3.hashCode();
        if (!string3.equals(HTML_TAG_SPAN)) {
            if (string3.equals(HTML_TAG_A)) {
                this.aEndTag(n, n2, string2, editable, xMLReader);
            }
        } else {
            this.spanEndTag(n, n2, string2, editable, xMLReader);
        }
    }

    private void spanStartTag(String string2, Editable editable, XMLReader xMLReader) {
        this.parseCssStyle(HtmlTagHelper.getAttribute(xMLReader, "style"), editable);
    }

    private void spanEndTag(int n, int n2, String string2, Editable editable, XMLReader xMLReader) {
        CssStyle cssStyle = HtmlTagHelper.getLast((Spanned)editable, CssStyle.class);
        if (cssStyle == null) {
            return;
        }
        if (cssStyle.color != 0) {
            Editable editable2 = editable;
            n = editable.getSpanStart((Object)cssStyle);
            editable2.removeSpan((Object)cssStyle);
            editable2.setSpan((Object)new ForegroundColorSpan(cssStyle.color), n, n2, 33);
        }
    }

    private void aStartTag(String object, Editable editable, XMLReader xMLReader) {
        LinkHolder linkHolder;
        Editable editable2 = editable;
        String string2 = HtmlTagHelper.getAttribute(xMLReader, "href");
        object = linkHolder;
        linkHolder = new LinkHolder(string2);
        int n = editable2.length();
        editable2.setSpan(object, n, n, 17);
    }

    private void aEndTag(int n, int n2, String string2, Editable object, XMLReader xMLReader) {
        final LinkHolder linkHolder = HtmlTagHelper.getLast((Spanned)object, LinkHolder.class);
        if (linkHolder != null) {
            ClickableSpan clickableSpan;
            Editable editable = object;
            int n3 = editable.getSpanStart((Object)linkHolder);
            editable.removeSpan((Object)linkHolder);
            object = clickableSpan;
            clickableSpan = new ClickableSpan(){

                public void onClick(View view) {
                    if (HtmlTagHandler.this.onTextClickListener != null) {
                        HtmlTagHandler.this.onTextClickListener.onTextClick(linkHolder.url);
                    }
                    Log.i((String)HtmlTagHandler.TAG, (String)("click custom url =" + linkHolder.url));
                }
            };
            editable.setSpan(object, n3, n2, 33);
        }
    }

    private void resetLinkSpan(Spannable spannable, URLSpan uRLSpan) {
        LinkHolder linkHolder;
        Spannable spannable2 = spannable;
        int n = spannable.getSpanStart((Object)uRLSpan);
        int n2 = spannable.getSpanEnd((Object)uRLSpan);
        spannable2.removeSpan((Object)uRLSpan);
        final LinkHolder linkHolder2 = linkHolder;
        linkHolder = new LinkHolder(uRLSpan.getURL());
        spannable2.setSpan((Object)new ClickableSpan(){

            public void onClick(View view) {
                if (HtmlTagHandler.this.onTextClickListener != null) {
                    HtmlTagHandler.this.onTextClickListener.onTextClick(linkHolder2.url);
                }
            }
        }, n, n2, 33);
    }

    private void parseCssStyle(String string2, Editable editable) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        int n = editable.length();
        for (String stringArray : string2.split(";")) {
            if (TextUtils.isEmpty((CharSequence)stringArray)) break;
            String[] n2 = stringArray.trim().split(":");
            if (!CSS_NAME_COLOR.equals(n2[0].trim())) continue;
            int n3 = this.parseColor(n2[1].trim().replaceAll(" ", "").toLowerCase());
            int n4 = n;
            editable.setSpan((Object)new CssStyle(0, n3), n4, n4, 17);
        }
    }

    private int parseColor(String string2) {
        int n = 0;
        if (!string2.startsWith("rgb") && !string2.startsWith("rgba")) {
            if (string2.length() == 7) {
                n = Color.parseColor((String)string2);
            }
        } else {
            String string3 = string2;
            n = string3.indexOf("(");
            String[] stringArray = string3.substring(n, string3.indexOf(")")).replaceAll(" ", "").replaceAll("\\(", "").split(",");
            if (stringArray.length == 3) {
                n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                n = Color.argb((int)255, (int)n, (int)n2, (int)n3);
            } else {
                n = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                int n5 = Integer.parseInt(stringArray[2]);
                n = Color.argb((int)Integer.parseInt(stringArray[3]), (int)n, (int)n4, (int)n5);
            }
        }
        return n;
    }

    public void handleTag(boolean n, String string2, Editable editable, XMLReader xMLReader) {
        if (n != 0) {
            HtmlTagHandler htmlTagHandler = this;
            htmlTagHandler.handleStartTag(string2, editable, xMLReader);
            htmlTagHandler.indexStack.push(editable.length());
        } else {
            n = this.indexStack.isEmpty() ? 0 : this.indexStack.pop();
            this.handleEndTag(n, editable.length(), string2, editable, xMLReader);
        }
    }

    public static interface OnTextClickListener {
        public void onTextClick(String var1);
    }

    public static class ATagSpan {
        public String href;

        public ATagSpan(String string2) {
            this.href = string2;
        }
    }

    public static class CssStyle {
        public int textSize;
        public int color;

        public CssStyle(int n, int n2) {
            this.textSize = n;
            this.color = n2;
        }
    }

    public static class LinkHolder {
        private static final int LINK_COLOR = Color.parseColor((String)"#00ff00");
        public String url;
        public int color;
        public boolean underLine;

        public LinkHolder(String string2) {
            this(string2, LINK_COLOR);
        }

        public LinkHolder(String string2, int n) {
            this(string2, n, false);
        }

        public LinkHolder(String string2, int n, boolean bl) {
            this.url = string2;
            this.color = n;
            this.underLine = bl;
        }
    }
}

