/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class TapTapSignUtil {
    TapTapSignUtil() {
    }

    private static String getTime() {
        return String.format(Locale.US, "%010d", System.currentTimeMillis() / 1000L);
    }

    private static String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    private static String mergeSign(String time, String randomCode, String httpType, String uri, String domain, String port, String other) {
        if (TextUtils.isEmpty((CharSequence)time) || TextUtils.isEmpty((CharSequence)randomCode) || TextUtils.isEmpty((CharSequence)httpType) || TextUtils.isEmpty((CharSequence)domain) || TextUtils.isEmpty((CharSequence)port)) {
            return null;
        }
        String prefix = time + "\n" + randomCode + "\n" + httpType + "\n" + uri + "\n" + domain + "\n" + port + "\n";
        prefix = TextUtils.isEmpty((CharSequence)other) ? prefix + "\n" : prefix + other + "\n";
        return prefix;
    }

    public static String getUA() {
        return "AntiAddictionAndroidSDK/3.16.5 " + System.getProperty("http.agent");
    }

    public static String getAuthorization(String url_string, String method, String keyid, String mac_key) {
        try {
            URL url = new URL(url_string);
            String time = TapTapSignUtil.getTime();
            String randomStr = TapTapSignUtil.getRandomString(5);
            String host = url.getHost();
            String uri = url_string.substring(url_string.lastIndexOf(host) + host.length());
            String port = "80";
            if (url_string.startsWith("https")) {
                port = "443";
            }
            String other = "";
            String sign = TapTapSignUtil.sign(TapTapSignUtil.mergeSign(time, randomStr, method, uri, host, port, other), mac_key);
            return "MAC " + TapTapSignUtil.getAuthorizationParam("id", keyid) + "," + TapTapSignUtil.getAuthorizationParam("ts", time) + "," + TapTapSignUtil.getAuthorizationParam("nonce", randomStr) + "," + TapTapSignUtil.getAuthorizationParam("mac", sign);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String sign(String signatureBaseString, String key) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] text = signatureBaseString.getBytes("UTF-8");
            byte[] signatureBytes = mac.doFinal(text);
            signatureBytes = Base64.encode((byte[])signatureBytes, (int)2);
            String signature = new String(signatureBytes, "UTF-8");
            return signature;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getAuthorizationParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return key + "=\"" + value + "\"";
    }
}

