/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.utils;

import android.util.Base64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class DataUtil {
    private static final String TAG = DataUtil.class.getSimpleName() + " --> ";
    private static final String KEY_ALGORITHM = "AES";
    public static final int SECRET_KEY_LENGTH = 16;
    private static final Charset CHARSET_UTF8 = StandardCharsets.UTF_8;
    private static final String DEFAULT_VALUE = "0";
    private static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

    public static String encrypt(String data, String secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(1, DataUtil.getSecretKey(secretKey));
            byte[] encryptByte = cipher.doFinal(data.getBytes(CHARSET_UTF8));
            return DataUtil.base64Encode(encryptByte);
        }
        catch (Exception e) {
            DataUtil.handleException(e);
            return null;
        }
    }

    public static String decrypt(String encodeData, String secretKey) {
        try {
            byte[] data = DataUtil.base64Decode(encodeData.getBytes(CHARSET_UTF8));
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(2, DataUtil.getSecretKey(secretKey));
            byte[] result = cipher.doFinal(data);
            return new String(result, CHARSET_UTF8);
        }
        catch (Exception e) {
            DataUtil.handleException(e);
            return null;
        }
    }

    public static SecretKeySpec getSecretKey(String secretKey) {
        secretKey = DataUtil.toMakeKey(secretKey, 16, DEFAULT_VALUE);
        return new SecretKeySpec(secretKey.getBytes(CHARSET_UTF8), KEY_ALGORITHM);
    }

    private static String toMakeKey(String secretKey, int length, String text) {
        int strLen = secretKey.length();
        if (strLen < length) {
            StringBuilder builder = new StringBuilder();
            builder.append(secretKey);
            for (int i = 0; i < length - strLen; ++i) {
                builder.append(text);
            }
            secretKey = builder.toString();
        }
        return secretKey;
    }

    public static byte[] base64Decode(byte[] data) {
        return Base64.decode((byte[])data, (int)0);
    }

    public static String base64Encode(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)0);
    }

    private static void handleException(Exception e) {
        e.printStackTrace();
    }
}

