/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Dialog;
import android.app.FragmentManager;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.tapsdk.antiaddiction.entities.CommonConfig;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.entities.UIConfig;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddictionui.callback.AuthorizationResultCallback;
import com.tapsdk.antiaddictionui.utils.UIUtil;
import com.tapsdk.antiaddictionui.widget.SafeDialogFragment;
import java.util.List;

public abstract class AbsBaseDialogFragment
extends SafeDialogFragment {
    protected static final int TAP_AUTHORIZATION_TYPE_0 = 0;
    protected static final int TAP_AUTHORIZATION_TYPE_1 = 1;
    protected static final int TAP_AUTHORIZATION_TYPE_2 = 2;
    protected static final int GAME_AUTHORIZATION_TYPE_3 = 3;
    protected static final int GAME_AUTHORIZATION_TYPE_4 = 4;
    protected static final int GAME_AUTHORIZATION_TYPE_5 = 5;
    public final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected AuthorizationResultCallback mCallback;
    protected List<Prompt> authIdentifyPromptList;

    public abstract int layoutResId();

    public abstract void initView(View var1);

    public abstract void handleArgumentsData();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        Window window;
        Dialog dialog = this.getDialog();
        if (dialog != null && (window = dialog.getWindow()) != null) {
            window.setFlags(0x1000000, 0x1000000);
        }
        if (!this.checkUIConfig()) {
            this.dismissAllowingStateLoss();
            return null;
        }
        this.handleArgumentsData();
        if (this.getArguments() == null) {
            this.dismissAllowingStateLoss();
            return null;
        }
        View view = inflater.inflate(this.layoutResId(), container, false);
        if (view != null) {
            this.initView(view);
        }
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog == null || this.getActivity() == null || this.getActivity().getWindowManager() == null || dialog.getWindow() == null) {
            return;
        }
        WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
        lp.width = UIUtil.dp2px((Context)this.getActivity(), 335.0f);
        lp.height = UIUtil.dp2px((Context)this.getActivity(), 320.0f);
        if (this.getDialog() != null && this.getDialog().getWindow() != null) {
            Window window = this.getDialog().getWindow();
            View decorView = window.getDecorView();
            if (Build.VERSION.SDK_INT >= 28) {
                lp.layoutInDisplayCutoutMode = 1;
                window.setAttributes(lp);
            }
            decorView.setSystemUiVisibility(1024);
        }
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
    }

    private boolean checkUIConfig() {
        UIConfig uiConfig;
        CommonConfig config = AntiAddictionSettings.getInstance().getCommonConfig();
        if (config != null && (uiConfig = config.uiConfig) != null) {
            this.authIdentifyPromptList = uiConfig.authIdentifyPromptList;
            return this.authIdentifyPromptList != null && this.authIdentifyPromptList.size() > 0;
        }
        return false;
    }

    protected Prompt getUIConfigPromptByType(int type) {
        Prompt resultPrompt = null;
        for (Prompt prompt : this.authIdentifyPromptList) {
            if (prompt.type != type) continue;
            resultPrompt = prompt;
            break;
        }
        return resultPrompt;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(1);
        return dialog;
    }

    public void show(FragmentManager manager, String tag) {
        try {
            super.show(manager, tag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

