/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.AntiAddictionCallback;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.AntiAddictionLoginCallback;
import com.tapsdk.antiaddiction.Config;
import com.tapsdk.antiaddiction.config.AntiAddictionFunctionConfig;
import com.tapsdk.antiaddiction.entities.TwoTuple;
import com.tapsdk.antiaddiction.entities.response.CheckPayResult;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.entities.response.SubmitPayResult;
import com.tapsdk.antiaddiction.models.ConfigModel;
import com.tapsdk.antiaddiction.models.IdentifyModel;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.reactor.schedulers.Schedulers;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.NetServerErrorChecker;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.skynet.logging.HttpLoggingInterceptor;
import com.tapsdk.antiaddiction.skynet.okhttp3.HttpUrl;
import com.tapsdk.antiaddiction.skynet.okhttp3.Interceptor;
import com.tapsdk.antiaddiction.skynet.okhttp3.OkHttpClient;
import com.tapsdk.antiaddiction.skynet.okhttp3.Request;
import com.tapsdk.antiaddiction.skynet.okhttp3.Response;
import com.tapsdk.antiaddiction.skynet.retrofit2.CallAdapter;
import com.tapsdk.antiaddiction.skynet.retrofit2.Converter;
import com.tapsdk.antiaddiction.skynet.retrofit2.Retrofit;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson.GsonConverterFactory;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.FileUtils;
import com.tapsdk.antiaddictionui.AntiAddictionUICallback;
import com.tapsdk.antiaddictionui.Callback;
import com.tapsdk.antiaddictionui.Callback0;
import com.tapsdk.antiaddictionui.IAntiAddictionUI;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.TapTapSignUtil;
import com.tapsdk.antiaddictionui.model.TapTapModel;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.utils.ToastUtils;
import com.tapsdk.antiaddictionui.widget.AntiAlertDialog;
import com.tapsdk.antiaddictionui.widget.AntiToastManager;
import com.tapsdk.antiaddictionui.widget.DialogGameHealthReminder;
import com.tapsdk.antiaddictionui.widget.DialogGameRealName;
import com.tapsdk.antiaddictionui.widget.DialogTapAuthorization;
import com.tapsdk.antiaddictionui.widget.SandboxAuthIdentityFragment;
import com.tds.common.entities.AccessToken;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;

public class AntiAddictionUIImpl
implements IAntiAddictionUI {
    private final ConfigModel configModel = new ConfigModel();
    private boolean initialized = false;
    private String clientId = "";
    private Config config;
    private Subscription startUpSubscription;
    private boolean useMock = false;
    private boolean isRND = false;
    private String currentUserIdentifier = "";
    private boolean noticeGameCanPlay = false;
    private boolean isReady = false;
    private AntiAddictionUICallback mAntiAddictionUICallback;
    WeakReference<Activity> currentActivityWeakReference = null;

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    @Deprecated
    public void init(Activity activity, String gameIdentifier, AntiAddictionFunctionConfig antiAddictionFunctionConfig, AntiAddictionUICallback callback) {
        if (this.initialized) {
            return;
        }
        this.clientId = gameIdentifier;
        this.mAntiAddictionUICallback = callback;
        this.initSkynet(activity, callback);
        if (this.currentActivityWeakReference == null || this.currentActivityWeakReference.get() != activity) {
            this.currentActivityWeakReference = new WeakReference<Activity>(activity);
        }
        if (!AntiAddictionKit.initialized()) {
            AntiAddictionKit.init((Context)activity, (String)gameIdentifier, (AntiAddictionFunctionConfig)antiAddictionFunctionConfig, (AntiAddictionCallback)this.makeAntiAddictionCallback(callback));
        }
        AntiAddictionLogger.d((String)"init success");
        this.initialized = true;
    }

    @Override
    public void init(Activity activity, Config config, AntiAddictionUICallback callback) {
        if (this.initialized) {
            return;
        }
        if (config == null) {
            throw new RuntimeException("AntiAddiction init fail(config can't be null)");
        }
        this.clientId = config.clientId;
        this.config = config;
        this.mAntiAddictionUICallback = callback;
        this.initSkynet(activity, callback);
        if (this.currentActivityWeakReference == null || this.currentActivityWeakReference.get() != activity) {
            this.currentActivityWeakReference = new WeakReference<Activity>(activity);
        }
        if (!AntiAddictionKit.initialized()) {
            AntiAddictionKit.init((Context)activity, (Config)config, (AntiAddictionCallback)this.makeAntiAddictionCallback(callback));
        }
        AntiAddictionLogger.d((String)"init success");
        this.initialized = true;
    }

    private AntiAddictionCallback makeAntiAddictionCallback(final AntiAddictionUICallback callback) {
        return new AntiAddictionCallback(){

            public void onCallback(int code, Map<String, Object> extras) {
                boolean isTimeLimitStrict = false;
                boolean isNightStrict = false;
                AntiAddictionLogger.d((String)("AntiAddiction result:" + code + "," + (extras != null ? extras.toString() : "")));
                switch (code) {
                    case 500: {
                        if (AntiAddictionKit.currentUserAgeLimit() == 18) {
                            callback.onCallback(500, null);
                            AntiAddictionUIImpl.this.isReady = true;
                            AntiAddictionKit.enterGame();
                            break;
                        }
                        AntiAddictionUIImpl.this.noticeGameCanPlay = true;
                        break;
                    }
                    case 1030: {
                        isNightStrict = true;
                    }
                    case 1050: {
                        isTimeLimitStrict = true;
                    }
                    case 1095: {
                        int reminderType;
                        String negativeButtonStr = "";
                        String positiveButtonStr = "";
                        String title = "";
                        String description = "";
                        if (isNightStrict) {
                            reminderType = 1003;
                            negativeButtonStr = "";
                            positiveButtonStr = "\u9000\u51fa\u6e38\u620f";
                        } else if (isTimeLimitStrict) {
                            reminderType = 1001;
                            negativeButtonStr = "";
                            positiveButtonStr = "\u9000\u51fa\u6e38\u620f";
                        } else {
                            reminderType = 1004;
                            negativeButtonStr = "";
                            positiveButtonStr = "\u8fdb\u5165\u6e38\u620f";
                        }
                        if (extras != null) {
                            if (extras.containsKey("title")) {
                                title = (String)extras.get("title");
                            }
                            if (extras.containsKey("description")) {
                                description = (String)extras.get("description");
                            }
                        }
                        if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                            return;
                        }
                        AntiAddictionUIImpl.this.openReminderDialog((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), AntiAddictionUIImpl.this.currentUserIdentifier, reminderType, title, description, negativeButtonStr, positiveButtonStr, new DialogGameHealthReminder.Callback(){

                            @Override
                            public void navigateToRealName() {
                            }

                            @Override
                            public void enterGame() {
                                if (AntiAddictionUIImpl.this.noticeGameCanPlay) {
                                    AntiAddictionUIImpl.this.isReady = true;
                                    callback.onCallback(500, null);
                                    AntiAddictionKit.enterGame();
                                    AntiAddictionUIImpl.this.noticeGameCanPlay = false;
                                }
                            }

                            @Override
                            public void confirmNotice() {
                            }
                        });
                        callback.onCallback(code, extras);
                        break;
                    }
                    case 1000: {
                        callback.onCallback(1000, null);
                        break;
                    }
                    case 9002: {
                        callback.onCallback(9002, null);
                        break;
                    }
                    case 1001: {
                        callback.onCallback(1001, null);
                        break;
                    }
                }
            }
        };
    }

    private static String getMockResponse(Context context, Interceptor.Chain chain) {
        HttpUrl httpUrl = chain.request().url();
        String path = httpUrl.url().toString();
        AntiAddictionLogger.d((String)("getMockResponse " + path));
        if (path.contains("/account/idcard/v1")) {
            return FileUtils.getJsonFromAssetsFile((Context)context, (String)"mock_taptap_identify_info.json");
        }
        return "";
    }

    private void initSkynet(Activity activity, final AntiAddictionUICallback callback) {
        OkHttpClient.Builder taptapOpenServiceOkHttpBuilder = new OkHttpClient.Builder();
        HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor();
        logInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        Interceptor authInterceptor = new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                AccessToken token = TapTapModel.accessToken;
                if (TextUtils.isEmpty((CharSequence)token.accessToken)) {
                    callback.onCallback(1000, null);
                    throw new RuntimeException("taptap accessToken invalid");
                }
                Request originRequest = chain.request();
                Request newRequest = chain.request().newBuilder().header("User-Agent", TapTapSignUtil.getUA()).header("Authorization", TapTapSignUtil.getAuthorization(originRequest.url().toString(), originRequest.method(), token.kid, token.macKey)).build();
                return chain.proceed(newRequest);
            }
        };
        taptapOpenServiceOkHttpBuilder.addInterceptor(authInterceptor);
        taptapOpenServiceOkHttpBuilder.addInterceptor((Interceptor)logInterceptor);
        Retrofit antiAddictionRetrofit = new Retrofit.Builder().baseUrl(this.isRND ? "https://open.api.xdrnd.cn" : "https://openapi.taptap.com").client(taptapOpenServiceOkHttpBuilder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create(Collections.singletonList(new NetServerErrorChecker()))).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build();
        Skynet.getInstance().registerRetrofit(Skynet.RETROFIT_FOR_TAPTAP_OPEN_SERVICE, antiAddictionRetrofit);
    }

    @Override
    public void startup(Activity activity, String userIdentifier) {
        if (this.config != null) {
            this.startup(activity, this.config.useTapLogin, userIdentifier);
        } else {
            this.startup(activity, false, userIdentifier);
        }
    }

    @Override
    @Deprecated
    public void startup(Activity activity, boolean useTapLogin, final String userIdentifier) {
        this.currentUserIdentifier = userIdentifier;
        if (TextUtils.isEmpty((CharSequence)userIdentifier)) {
            ToastUtils.safeToast(activity, "userIdentifier is empty");
            return;
        }
        final boolean postUseTapLogin = useTapLogin;
        if (this.currentActivityWeakReference == null || this.currentActivityWeakReference.get() != activity) {
            this.currentActivityWeakReference = new WeakReference<Activity>(activity);
        }
        if (this.startUpSubscription != null && !this.startUpSubscription.isUnsubscribed()) {
            this.startUpSubscription.unsubscribe();
        }
        this.startUpSubscription = this.configModel.fetchAndSetupCommonConfigAsync((Context)activity, this.clientId).subscribeOn(Schedulers.newThread()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<Boolean>(){

            public void onStart() {
                super.onStart();
                AntiToastManager.instance().showLoading((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get());
                AntiAddictionLogger.d((String)"AntiAddiction startUp onStart");
            }

            public void onCompleted() {
                AntiAddictionLogger.d((String)"AntiAddiction startUp onCompleted");
            }

            public void onError(Throwable e) {
                AntiToastManager.instance().dismissLoading();
                String errMsg = "";
                errMsg = !TextUtils.isEmpty((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName();
                AntiAddictionLogger.e((String)("AntiAddiction startUp " + errMsg));
            }

            public void onNext(Boolean result) {
                AntiAddictionLogger.d((String)"AntiAddiction startUp onNext");
                AntiToastManager.instance().dismissLoading();
                if (result.booleanValue()) {
                    if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                        return;
                    }
                    AntiAddictionUIImpl.this.checkUserAuthIdentify((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, postUseTapLogin);
                } else {
                    AntiAddictionLogger.e((String)"AntiAddiction startUp shouldn't appear here");
                }
            }
        });
    }

    @Override
    public void checkPayLimit(final Activity activity, long amount, final Callback<CheckPayResult> callback) {
        if (this.currentActivityWeakReference == null || this.currentActivityWeakReference.get() != activity) {
            this.currentActivityWeakReference = new WeakReference<Activity>(activity);
        }
        AntiAddictionKit.checkPayLimit((long)amount, (com.tapsdk.antiaddiction.Callback)new com.tapsdk.antiaddiction.Callback<CheckPayResult>(){

            public void onSuccess(final CheckPayResult result) {
                if (result.status) {
                    callback.onSuccess(result);
                } else {
                    callback.onSuccess(result);
                    if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                        return;
                    }
                    AntiAddictionUIImpl.this.openReminderDialog((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), AntiAddictionUIImpl.this.currentUserIdentifier, 1005, result.title, result.description, "", activity.getString(R.string.antiaddictionui_return_game), new DialogGameHealthReminder.Callback(){

                        @Override
                        public void navigateToRealName() {
                        }

                        @Override
                        public void enterGame() {
                        }

                        @Override
                        public void confirmNotice() {
                            callback.onSuccess(result);
                        }
                    });
                }
            }

            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        });
    }

    @Override
    public void submitPayResult(long amount, com.tapsdk.antiaddiction.Callback<SubmitPayResult> callback) {
        AntiAddictionKit.submitPayResult((long)amount, callback);
    }

    private void tryLoginAntiAddiction(final String userIdentifier, final String accessToken, final int ageLimit) {
        AntiAddictionKit.login((String)userIdentifier, (String)accessToken, (int)ageLimit, (AntiAddictionLoginCallback)new AntiAddictionLoginCallback(){

            public void onSuccess() {
            }

            public void onError(Throwable throwable) {
                Callback0 callback0 = new Callback0(){

                    @Override
                    public void onResult() {
                        AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, accessToken, ageLimit);
                    }
                };
                AntiAddictionUIImpl.this.showLoginFailAndTryAgain(throwable, userIdentifier, callback0);
            }
        });
    }

    private void checkUserAuthIdentify(final Activity activity, final String userIdentifier, final boolean useTapLogin) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        if (this.currentActivityWeakReference == null || this.currentActivityWeakReference.get() != activity) {
            this.currentActivityWeakReference = new WeakReference<Activity>(activity);
        }
        AntiAddictionKit.checkStandaloneCacheAndFetchUserIdentifyState((String)this.clientId, (String)userIdentifier, (com.tapsdk.antiaddiction.Callback)new com.tapsdk.antiaddiction.Callback<IdentifyState>(){

            public void onSuccess(IdentifyState state) {
                if (state.identifyState == 0) {
                    AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, state.antiAddictionToken, state.ageLimit);
                } else if (state.identifyState == 1) {
                    if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                        return;
                    }
                    AntiAddictionUIImpl.this.openReminderDialog((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, 1002, "", "", "", "", new DialogGameHealthReminder.Callback(){

                        @Override
                        public void navigateToRealName() {
                        }

                        @Override
                        public void enterGame() {
                        }

                        @Override
                        public void confirmNotice() {
                        }
                    });
                } else if (!state.hasAuthRecord) {
                    if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                        return;
                    }
                    if (!TapTapModel.isRunInTapSandboxAndProcessMatchCore() || !TapTapModel.checkTapSupportIdentity((Context)AntiAddictionUIImpl.this.currentActivityWeakReference.get())) {
                        if (useTapLogin && !state.antiAddictionToken.equals("standalone_anti_addiction_token")) {
                            AntiAddictionUIImpl.this.navigateToTapTapTapTapFastCertification((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier);
                        } else {
                            AntiAddictionUIImpl.this.navigateToAuthIdentifier((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, false);
                        }
                    } else {
                        AntiAddictionLogger.d((String)" game running in sandbox and identity enable");
                        AntiAddictionUIImpl.this.navigateToTapForSandboxCertification((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier);
                    }
                } else {
                    AntiAddictionUIImpl.this.navigateToAuthIdentifier((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, true);
                }
            }

            public void onError(final Throwable throwable) {
                AntiAddictionLogger.e((String)("checkUserAuthIdentify: onError:" + throwable.getMessage()));
                if (AntiAddictionUIImpl.this.currentActivityWeakReference == null) {
                    return;
                }
                if (ActivityUtils.isActivityNotAlive((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get())) {
                    return;
                }
                AntiAddictionKit.checkIfStartStandAloneMode((com.tapsdk.antiaddiction.Callback)new com.tapsdk.antiaddiction.Callback<Boolean>(){

                    public void onSuccess(Boolean enableStandaloneMode) {
                        AntiAddictionUIImpl.this.checkCacheAndLogin(throwable, activity, userIdentifier, useTapLogin);
                    }

                    public void onError(Throwable throwable2) {
                        Callback0 callback0 = new Callback0(){

                            @Override
                            public void onResult() {
                                AntiAddictionUIImpl.this.checkUserAuthIdentify((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, useTapLogin);
                            }
                        };
                        AntiAddictionUIImpl.this.showLoginFailAndTryAgain(throwable2, userIdentifier, callback0);
                    }
                });
            }
        });
    }

    private boolean preCheckUserCache(Activity activity, String userIdentifier) {
        TwoTuple cacheUserInfo = AntiAddictionSettings.getInstance().getCachedUserInfo((Context)activity, userIdentifier);
        if (cacheUserInfo != null && cacheUserInfo.firstParam != null && !((String)cacheUserInfo.firstParam).isEmpty()) {
            if (!"standalone_anti_addiction_token".equals(cacheUserInfo.firstParam)) {
                return true;
            }
            return AntiAddictionKit.isStandalone();
        }
        return false;
    }

    private void checkCacheAndLogin(Throwable throwable, Activity activity, final String userIdentifier, final boolean useTapLogin) {
        if (this.preCheckUserCache(activity, userIdentifier)) {
            TwoTuple cacheUserInfo = AntiAddictionSettings.getInstance().getCachedUserInfo((Context)activity, userIdentifier);
            this.tryLoginAntiAddiction(userIdentifier, (String)cacheUserInfo.firstParam, (Integer)cacheUserInfo.secondParam);
            return;
        }
        Callback0 callback0 = new Callback0(){

            @Override
            public void onResult() {
                AntiAddictionUIImpl.this.checkUserAuthIdentify((Activity)AntiAddictionUIImpl.this.currentActivityWeakReference.get(), userIdentifier, useTapLogin);
            }
        };
        this.showLoginFailAndTryAgain(throwable, userIdentifier, callback0);
    }

    private void showLoginFailAndTryAgain(Throwable throwable, String userIdentifier, Callback0 callback0) {
        if (this.currentActivityWeakReference == null) {
            return;
        }
        if (ActivityUtils.isActivityNotAlive((Activity)this.currentActivityWeakReference.get())) {
            return;
        }
        Activity activity = (Activity)this.currentActivityWeakReference.get();
        String message = activity.getString(R.string.antiaddictionui_fetch_realname_fail);
        if (!(throwable instanceof AntiServerException) || ((AntiServerException)throwable).statusCode == -1) {
            message = activity.getString(R.string.antiaddictionui_network_error);
        }
        String positiveButtonStr = activity.getString(R.string.antiaddictionui_retry);
        AntiAlertDialog.openAlert((Activity)this.currentActivityWeakReference.get(), "", message, positiveButtonStr, callback0, false);
    }

    private void navigateToAuthIdentifier(Activity activity, final String userIdentifier, boolean hasAuthRecord) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        DialogGameRealName dialogGameRealName = DialogGameRealName.getInstance(this.clientId, userIdentifier, hasAuthRecord, new DialogGameRealName.RealNameResultCallback(){

            @Override
            public void onRealNameSuccess(IdentifyState result) {
                AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, result.antiAddictionToken, result.ageLimit);
            }

            @Override
            public void onCloseRealName() {
                if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                    AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(9002, null);
                }
            }
        });
        if (!dialogGameRealName.isAdded()) {
            dialogGameRealName.show(activity.getFragmentManager(), "DialogGameRealName");
        }
    }

    private void navigateToTapTapTapTapFastCertification(final Activity activity, final String userIdentifier) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        DialogTapAuthorization dialog = DialogTapAuthorization.getInstance(this.clientId, AntiAddictionSettings.getInstance().getCommonConfig().gameName, userIdentifier, new DialogTapAuthorization.AuthorizationCallback(){

            @Override
            public void navigateToRealName() {
                DialogGameRealName dialogGameRealName = DialogGameRealName.getInstance(AntiAddictionUIImpl.this.clientId, userIdentifier, false, new DialogGameRealName.RealNameResultCallback(){

                    @Override
                    public void onRealNameSuccess(IdentifyState result) {
                        AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, result.antiAddictionToken, result.ageLimit);
                    }

                    @Override
                    public void onCloseRealName() {
                        if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                            AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(9002, null);
                        }
                    }
                });
                if (!dialogGameRealName.isAdded()) {
                    dialogGameRealName.show(activity.getFragmentManager(), "DialogGameRealName");
                }
            }

            @Override
            public void onRealNameSuccess(IdentifyState identifyState) {
                if (identifyState.identifyState == 0) {
                    AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, identifyState.antiAddictionToken, identifyState.ageLimit);
                }
            }

            @Override
            public void navigateToUnderReview() {
                if (ActivityUtils.isActivityNotAlive(activity)) {
                    return;
                }
                DialogGameHealthReminder dialogGameHealthReminder = DialogGameHealthReminder.getInstance(AntiAddictionUIImpl.this.clientId, userIdentifier, 1002, "", "", "", "", new DialogGameHealthReminder.Callback(){

                    @Override
                    public void navigateToRealName() {
                    }

                    @Override
                    public void enterGame() {
                    }

                    @Override
                    public void confirmNotice() {
                        System.exit(0);
                    }
                });
                if (!dialogGameHealthReminder.isAdded()) {
                    dialogGameHealthReminder.show(activity.getFragmentManager(), "DialogGameRealName");
                }
            }

            @Override
            public void onCloseRealName() {
                if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                    AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(9002, null);
                }
            }
        });
        if (!dialog.isAdded()) {
            dialog.show(activity.getFragmentManager(), "DialogTapAuthorization");
        }
    }

    private void navigateToTapForSandboxCertification(Activity activity, final String userIdentifier) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        SandboxAuthIdentityFragment sandboxAuthIdentityFragment = SandboxAuthIdentityFragment.newInstance(this.clientId, userIdentifier, new SandboxAuthIdentityFragment.SandboxAuthIdentityCallback(){

            @Override
            public void onRealNameSuccess(IdentifyState result) {
                AntiAddictionLogger.d((String)" realName Success so login ");
                AntiAddictionUIImpl.this.tryLoginAntiAddiction(userIdentifier, result.antiAddictionToken, result.ageLimit);
            }

            @Override
            public void onRealNameFail(Throwable e) {
                AntiAddictionLogger.d((String)("  onRealNameFail error =  " + e.getMessage()));
                if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                    AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(9001, null);
                }
            }

            @Override
            public void onUploadIdentifyFail(Throwable e) {
                AntiAddictionLogger.d((String)("  onUploadIdentifyFail e = " + e.getMessage()));
                if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                    AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(500, null);
                }
            }

            @Override
            public void onUseTapAntiAddition(boolean needStrict) {
                AntiAddictionLogger.d((String)("  onUseTapAntiAddition needStrict = " + needStrict));
                if (AntiAddictionUIImpl.this.mAntiAddictionUICallback != null) {
                    AntiAddictionUIImpl.this.mAntiAddictionUICallback.onCallback(needStrict ? 1030 : 500, null);
                }
            }
        });
        if (!sandboxAuthIdentityFragment.isAdded()) {
            sandboxAuthIdentityFragment.show(activity.getFragmentManager(), "SandboxAuthIdentityFragment");
        }
    }

    private void openReminderDialog(Activity activity, String userIdentifer, int reminderType, String title, String description, String negativeButtonStr, String positiveButtonStr, DialogGameHealthReminder.Callback callback) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        DialogGameHealthReminder dialogGameHealthReminder = DialogGameHealthReminder.getInstance(this.clientId, userIdentifer, reminderType, title, description, negativeButtonStr, positiveButtonStr, callback);
        if (!dialogGameHealthReminder.isAdded()) {
            dialogGameHealthReminder.show(activity.getFragmentManager(), "DialogGameRealName");
        }
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public void setRndEnvironment(String newKey) {
        this.isRND = true;
        IdentifyModel.switchIdentifyPublicKey((String)newKey);
    }
}

