/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.widget.AntiAddictionProgressToast;

public enum AntiToastManager {
    INSTANCE;

    public static final int LENGTH_SHORT = 0;
    public static final int LENGTH_LONG = 1;
    private static final int TIME_OUT = 15000;
    private AntiAddictionProgressToast mToast;
    private static final String TAG = "AntiToastManager";
    private volatile boolean show;
    private static HandlerThread handlerThread;
    private static Handler handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AntiToastManager instance() {
        Class<AntiToastManager> clazz = AntiToastManager.class;
        synchronized (AntiToastManager.class) {
            AntiToastManager.initHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static void initHandler() {
        if (handlerThread == null) {
            handlerThread = new HandlerThread(TAG, -4);
            handlerThread.start();
            handler = new Handler(handlerThread.getLooper());
        }
    }

    public void showLoading(Activity activity) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        this.showLoadingActually(activity, 15000);
    }

    public void showLoading(Activity activity, int duration) {
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        this.showLoadingActually(activity, duration);
    }

    private void showLoadingActually(final Activity activity, int duration) {
        if (activity == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AntiToastManager.this.show && AntiToastManager.this.mToast != null) {
                    AntiToastManager.this.mToast.dismissAllowingStateLoss();
                }
                AntiToastManager.this.mToast = AntiAddictionProgressToast.newInstance();
                try {
                    AntiToastManager.this.mToast.show(activity.getFragmentManager(), AntiAddictionProgressToast.TAG);
                }
                catch (Exception e) {
                    AntiAddictionLogger.e((String)e.getMessage());
                }
                AntiToastManager.this.show = true;
            }
        });
        if (duration != Integer.MAX_VALUE) {
            handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AntiToastManager.this.dismissLoading();
                }
            }, (long)duration);
        }
    }

    public void show(Activity activity, String message, int duration) {
        Toast customToast = new Toast((Context)activity);
        View customView = LayoutInflater.from((Context)activity).inflate(R.layout.antiaddictionui_view_toast_message, null);
        TextView tv = (TextView)customView.findViewById(R.id.tv_toast_message);
        tv.setText((CharSequence)message);
        customToast.setView(customView);
        if (duration == 0) {
            customToast.setDuration(0);
        } else if (duration == 1) {
            customToast.setDuration(1);
        }
        customToast.setGravity(17, 0, 0);
        customToast.show();
    }

    public void dismissLoading() {
        if (handler == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (AntiToastManager.this.show) {
                    try {
                        AntiToastManager.this.mToast.dismissAllowingStateLoss();
                    }
                    catch (Exception e) {
                        AntiAddictionLogger.e((String)e.getMessage());
                    }
                }
                AntiToastManager.this.show = false;
            }
        });
    }
}

