/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.os.Bundle;
import android.text.Html;
import android.view.View;
import android.widget.TextView;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.utils.UIConfigHelper;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.widget.AbsBaseDialogFragment;

public class DialogGameHealthReminder
extends AbsBaseDialogFragment
implements View.OnClickListener {
    public static final String TAG = "DialogAccountLimit";
    public static final int TYPE_TIME_LIMIT = 1001;
    public static final int TYPE_DURING_CERTIFICATION = 1002;
    public static final int TYPE_OUT_OF_PLAYABLE_TIME = 1003;
    public static final int TYPE_REMAIN_TIME_TIPS = 1004;
    public static final int TYPE_PAY_LIMIT = 1005;
    private TextView tvTitle;
    private TextView tvLimitTips;
    private TextView tvSwitchAccountButton;
    private TextView tvExitGameButton;
    private TextView tvNavigation2RealNameButton;
    private TextView tvFunctionButton;
    private String clientId;
    private String userIdentifier;
    private String title;
    private String description;
    private String negativeButtonStr;
    private String positiveButtonStr;
    private int currentLimitType;
    private Callback reminderCallback;

    public static DialogGameHealthReminder getInstance(String clientId, String userIdentifier, int limitType, String title, String description, String negativeButton, String positiveButton, Callback reminderCallback) {
        DialogGameHealthReminder dialog = new DialogGameHealthReminder();
        Bundle args = new Bundle();
        args.putString("client_id", clientId);
        args.putString("user_identifier", userIdentifier);
        args.putInt("key_limit_type", limitType);
        args.putString("key_title", title);
        args.putString("key_desc", description);
        args.putString("key_negative_button", negativeButton);
        args.putString("key_positive_button", positiveButton);
        dialog.setArguments(args);
        dialog.reminderCallback = reminderCallback;
        return dialog;
    }

    @Override
    public int layoutResId() {
        return R.layout.antiaddictionui_dialog_game_health_reminder;
    }

    @Override
    public void initView(View view) {
        View titleBar = view.findViewById(R.id.include_title_bar);
        this.tvTitle = (TextView)titleBar.findViewById(R.id.tv_title);
        this.tvLimitTips = (TextView)view.findViewById(R.id.tv_limit_tips);
        this.tvSwitchAccountButton = (TextView)view.findViewById(R.id.tv_switch_account_button);
        this.tvExitGameButton = (TextView)view.findViewById(R.id.tv_exit_game_button);
        this.tvNavigation2RealNameButton = (TextView)view.findViewById(R.id.tv_navigate_to_real_name_button);
        this.tvFunctionButton = (TextView)view.findViewById(R.id.tv_function_button);
        this.tvSwitchAccountButton.setOnClickListener((View.OnClickListener)this);
        this.tvExitGameButton.setOnClickListener((View.OnClickListener)this);
        this.tvNavigation2RealNameButton.setOnClickListener((View.OnClickListener)this);
        this.tvFunctionButton.setOnClickListener((View.OnClickListener)this);
        this.updateButtonView();
        this.tvSwitchAccountButton.setVisibility(AntiAddictionKit.showSwitchAccount() ? 0 : 8);
        Prompt prompt = null;
        if (this.currentLimitType == 1002) {
            prompt = UIConfigHelper.INSTANCE.duringCertificationPrompt;
        } else {
            prompt = new Prompt();
            prompt.title = this.title;
            prompt.description = this.description;
            prompt.negativeButton = this.negativeButtonStr;
            prompt.positiveButton = this.positiveButtonStr;
        }
        if (prompt != null) {
            this.tvTitle.setText((CharSequence)prompt.title);
            this.tvLimitTips.setText((CharSequence)Html.fromHtml((String)prompt.description));
            this.tvExitGameButton.setText((CharSequence)prompt.negativeButton);
            this.tvNavigation2RealNameButton.setText((CharSequence)prompt.positiveButton);
            this.tvFunctionButton.setText((CharSequence)prompt.positiveButton);
        }
    }

    private void updateButtonView() {
        if (this.currentLimitType == 1001) {
            this.tvExitGameButton.setVisibility(8);
            this.tvNavigation2RealNameButton.setVisibility(8);
            this.tvFunctionButton.setVisibility(0);
        } else {
            this.tvExitGameButton.setVisibility(8);
            this.tvNavigation2RealNameButton.setVisibility(8);
            this.tvFunctionButton.setVisibility(0);
        }
        if (this.currentLimitType == 1004 || this.currentLimitType == 1005) {
            this.tvSwitchAccountButton.setVisibility(8);
        } else {
            this.tvSwitchAccountButton.setVisibility(0);
        }
    }

    @Override
    public void handleArgumentsData() {
        Bundle args = this.getArguments();
        if (args != null) {
            this.clientId = args.getString("client_id");
            this.userIdentifier = args.getString("user_identifier");
            this.currentLimitType = args.getInt("key_limit_type");
            this.title = args.getString("key_title");
            this.description = args.getString("key_desc");
            this.negativeButtonStr = args.getString("key_negative_button");
            this.positiveButtonStr = args.getString("key_positive_button");
        }
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.tv_switch_account_button) {
            AntiAddictionKit.switchAccount();
            this.dismissAllowingStateLoss();
        } else if (viewId == R.id.tv_exit_game_button) {
            System.exit(0);
        } else if (viewId == R.id.tv_navigate_to_real_name_button) {
            this.dismissAllowingStateLoss();
            this.reminderCallback.navigateToRealName();
        } else if (viewId == R.id.tv_function_button) {
            this.dismissAllowingStateLoss();
            if (this.currentLimitType == 1002) {
                System.exit(0);
            } else if (this.currentLimitType == 1003) {
                System.exit(0);
            } else if (this.currentLimitType == 1004) {
                if (this.reminderCallback != null) {
                    this.reminderCallback.enterGame();
                }
            } else if (this.currentLimitType == 1005) {
                this.dismissAllowingStateLoss();
            } else if (this.currentLimitType == 1001) {
                System.exit(0);
            }
        }
    }

    public static interface Callback {
        public void navigateToRealName();

        public void enterGame();

        public void confirmNotice();
    }
}

