/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Activity;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.models.IdentifyModel;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.functions.Action1;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.reactor.schedulers.Schedulers;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.utils.UIConfigHelper;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.entities.response.TapTapIdentifyInfoResult;
import com.tapsdk.antiaddictionui.model.TapTapModel;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.utils.TapSDKHelper;
import com.tapsdk.antiaddictionui.utils.ToastUtils;
import com.tapsdk.antiaddictionui.widget.AbsBaseDialogFragment;
import com.tapsdk.antiaddictionui.widget.AntiToastManager;
import com.tds.common.entities.AccessToken;
import com.tds.common.oauth.AuthorizeModel;
import com.tds.common.oauth.exception.AuthorizeException;

public class DialogTapAuthorization
extends AbsBaseDialogFragment
implements View.OnClickListener {
    public static final String TAG = "DialogTapAuthorization";
    private ImageView ivBack;
    private TextView tvTitle;
    private ImageView ivClose;
    private LinearLayout llUseTapRealNameTips;
    private WebView webContent;
    private WebView webUserRealNameInfo;
    private TextView tvAgreeUseButton;
    private TextView tvDisagreeUseButton;
    private TextView tvUseTapAuthorizationConfirmButton;
    private String clientId;
    private String gameName;
    private String userIdentifier;
    private Subscription fetchTapTapInfoSubscription;
    private Subscription identifyFromTapTapSubscription;
    private boolean isIdentifyInfoResultEnable = false;
    private final TapTapModel tapTapModel = new TapTapModel();
    private final IdentifyModel identifyModel = new IdentifyModel();
    private TapTapIdentifyInfoResult identifyInfoResult;
    private AuthorizationCallback authorizationCallback;

    public static DialogTapAuthorization getInstance(String clientId, String gameName, String userIdentifier, AuthorizationCallback callback) {
        DialogTapAuthorization dialogTapAuthorization = new DialogTapAuthorization();
        Bundle bundle = new Bundle();
        bundle.putString("client_id", clientId);
        bundle.putString("game_name", gameName);
        bundle.putString("user_identifier", userIdentifier);
        dialogTapAuthorization.setArguments(bundle);
        dialogTapAuthorization.authorizationCallback = callback;
        return dialogTapAuthorization;
    }

    @Override
    public int layoutResId() {
        return R.layout.antiaddictionui_dialog_tap_authorization;
    }

    @Override
    public void initView(View contentView) {
        View vTitleBar = contentView.findViewById(R.id.include_title_bar);
        this.ivBack = (ImageView)vTitleBar.findViewById(R.id.iv_back);
        this.tvTitle = (TextView)vTitleBar.findViewById(R.id.tv_title);
        this.ivClose = (ImageView)vTitleBar.findViewById(R.id.iv_close);
        this.llUseTapRealNameTips = (LinearLayout)contentView.findViewById(R.id.ll_use_tap_real_name_tips);
        this.webContent = (WebView)contentView.findViewById(R.id.web_content);
        this.webUserRealNameInfo = (WebView)contentView.findViewById(R.id.web_user_real_name_info);
        this.tvAgreeUseButton = (TextView)contentView.findViewById(R.id.tv_agree_use_button);
        this.tvDisagreeUseButton = (TextView)contentView.findViewById(R.id.tv_disagree_use_button);
        this.tvUseTapAuthorizationConfirmButton = (TextView)contentView.findViewById(R.id.tv_use_tap_authorization_confirm_button);
        this.ivBack.setOnClickListener((View.OnClickListener)this);
        this.ivClose.setVisibility(0);
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.tvAgreeUseButton.setOnClickListener((View.OnClickListener)this);
        this.tvDisagreeUseButton.setOnClickListener((View.OnClickListener)this);
        this.tvUseTapAuthorizationConfirmButton.setOnClickListener((View.OnClickListener)this);
        Prompt prompt = UIConfigHelper.INSTANCE.tapAuthorizationTipsPrompt;
        if (prompt != null) {
            this.tvTitle.setText((CharSequence)prompt.title);
            String text = prompt.description;
            if (text != null) {
                if (text.contains("#{gameName}#")) {
                    text = text.replace("#{gameName}#", this.gameName == null ? "" : this.gameName);
                }
            } else {
                text = "";
            }
            this.webContent.loadDataWithBaseURL(null, text, "text/html", "utf-8", null);
            this.tvAgreeUseButton.setText((CharSequence)prompt.positiveButton);
            this.tvDisagreeUseButton.setText((CharSequence)prompt.negativeButton);
        }
    }

    @Override
    public void handleArgumentsData() {
        Bundle args = this.getArguments();
        if (args != null) {
            this.clientId = args.getString("client_id");
            this.gameName = args.getString("game_name");
            this.userIdentifier = args.getString("user_identifier");
        }
    }

    private void fetchTapTapIdentifyInfo() {
        if (this.fetchTapTapInfoSubscription != null && !this.fetchTapTapInfoSubscription.isUnsubscribed()) {
            return;
        }
        this.fetchTapTapInfoSubscription = this.tapTapModel.fetchTapTapIdentifyInfo(this.clientId).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Action1)new Action1<TapTapIdentifyInfoResult>(){

            public void call(TapTapIdentifyInfoResult tapTapIdentifyInfoResult) {
                DialogTapAuthorization.this.identifyInfoResult = tapTapIdentifyInfoResult;
                if (DialogTapAuthorization.this.checkIdentifyInfoValid(tapTapIdentifyInfoResult)) {
                    DialogTapAuthorization.this.isIdentifyInfoResultEnable = true;
                    DialogTapAuthorization.this.uploadTapTapAuthorizationInfo();
                } else {
                    DialogTapAuthorization.this.navigateToManualIdentify();
                }
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                DialogTapAuthorization.this.isIdentifyInfoResultEnable = false;
                DialogTapAuthorization.this.navigateToManualIdentify();
            }
        });
    }

    private void authorizeFromTapTapAndFetchTapTapIdentifyInfo() {
        final Activity activity = this.getActivity();
        if (ActivityUtils.isActivityNotAlive(activity)) {
            return;
        }
        try {
            this.tapTapModel.getTapIdentifyToken(activity, new AuthorizeModel.AuthorizationCallback(){

                public void onSuccess(AccessToken accessToken) {
                    if (accessToken != null) {
                        TapTapModel.accessToken = accessToken;
                        DialogTapAuthorization.this.fetchTapTapIdentifyInfo();
                    } else {
                        ToastUtils.safeToast(activity, "\u6388\u6743\u5931\u8d25\uff08\u672a\u83b7\u53d6\u6388\u6743Token\uff09");
                    }
                }

                public void onCancel() {
                    ToastUtils.safeToast(activity, "\u6388\u6743\u53d6\u6d88");
                }

                public void onError(AuthorizeException e) {
                    ToastUtils.safeToast(activity, "\u6388\u6743\u5931\u8d25");
                }
            });
        }
        catch (Exception e) {
            this.navigateToManualIdentify();
        }
    }

    private void uploadTapTapAuthorizationInfo() {
        String accessTokenJson;
        if (this.identifyInfoResult == null) {
            ToastUtils.safeToast(this.getActivity(), "\u7528\u6237\u5b9e\u540d\u4fe1\u606f\u5f02\u5e38");
            return;
        }
        if (this.identifyFromTapTapSubscription != null && !this.identifyFromTapTapSubscription.isUnsubscribed()) {
            this.identifyFromTapTapSubscription.unsubscribe();
        }
        int fromTapTap = TextUtils.isEmpty((CharSequence)(accessTokenJson = TapSDKHelper.getTapTokenJSONStr())) ? 0 : 1;
        this.identifyFromTapTapSubscription = this.identifyModel.identifyUserFromTapTap(this.clientId, this.userIdentifier, this.identifyInfoResult.code, fromTapTap).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<IdentifyState>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
                if (throwable instanceof AntiServerException && ((AntiServerException)throwable).statusCode >= 500) {
                    DialogTapAuthorization.this.navigateToManualIdentify();
                } else {
                    String errorMsg = throwable instanceof AntiServerException ? ToastUtils.fetchErrorMessage(throwable, "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f") : "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5";
                    ToastUtils.safeToast(DialogTapAuthorization.this.getActivity(), errorMsg);
                }
            }

            public void onNext(IdentifyState identifyState) {
                DialogTapAuthorization.this.processIdentifyResult(identifyState);
            }
        });
    }

    private void processIdentifyResult(IdentifyState identifyState) {
        if (identifyState == null) {
            this.dismissAllowingStateLoss();
            return;
        }
        if (identifyState.identifyState == 0) {
            ToastUtils.safeToast(this.getActivity(), "\u63d0\u4ea4\u6210\u529f");
            this.dismissAllowingStateLoss();
            if (this.authorizationCallback != null) {
                this.authorizationCallback.onRealNameSuccess(identifyState);
            }
        } else if (identifyState.identifyState == 1) {
            this.dismissAllowingStateLoss();
            if (this.authorizationCallback != null) {
                this.authorizationCallback.navigateToUnderReview();
            }
        } else {
            AntiToastManager.instance().show(this.getActivity(), "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f", 0);
        }
    }

    private void showFetchTapTapIdentifyInfoResult(boolean show) {
        if (show) {
            this.llUseTapRealNameTips.setVisibility(8);
            this.ivBack.setVisibility(0);
            this.webUserRealNameInfo.setVisibility(0);
            this.tvAgreeUseButton.setVisibility(8);
            this.tvDisagreeUseButton.setVisibility(8);
            this.tvUseTapAuthorizationConfirmButton.setVisibility(0);
        } else {
            this.llUseTapRealNameTips.setVisibility(0);
            this.ivBack.setVisibility(8);
            this.webUserRealNameInfo.setVisibility(8);
            this.tvAgreeUseButton.setVisibility(0);
            this.tvDisagreeUseButton.setVisibility(0);
            this.tvUseTapAuthorizationConfirmButton.setVisibility(8);
        }
    }

    private boolean checkIdentifyInfoValid(TapTapIdentifyInfoResult tapTapIdentifyInfoResult) {
        return tapTapIdentifyInfoResult != null && !TextUtils.isEmpty((CharSequence)tapTapIdentifyInfoResult.code);
    }

    private void navigateToManualIdentify() {
        if (this.authorizationCallback != null) {
            this.authorizationCallback.navigateToRealName();
        }
        this.dismissAllowingStateLoss();
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.iv_close) {
            if (this.authorizationCallback != null) {
                this.authorizationCallback.onCloseRealName();
            }
            this.dismissAllowingStateLoss();
        } else if (viewId == R.id.iv_back) {
            this.showFetchTapTapIdentifyInfoResult(false);
        } else if (viewId == R.id.tv_agree_use_button) {
            this.authorizeFromTapTapAndFetchTapTapIdentifyInfo();
        } else if (viewId == R.id.tv_disagree_use_button) {
            this.navigateToManualIdentify();
        } else if (viewId == R.id.tv_use_tap_authorization_confirm_button) {
            if (this.isIdentifyInfoResultEnable) {
                this.uploadTapTapAuthorizationInfo();
            } else {
                this.navigateToManualIdentify();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.fetchTapTapInfoSubscription != null) {
            this.fetchTapTapInfoSubscription.unsubscribe();
        }
        if (this.identifyFromTapTapSubscription != null) {
            this.identifyFromTapTapSubscription.unsubscribe();
        }
    }

    public static interface AuthorizationCallback {
        public void navigateToRealName();

        public void onRealNameSuccess(IdentifyState var1);

        public void navigateToUnderReview();

        public void onCloseRealName();
    }
}

