/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.models.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tapsdk.antiaddiction.entities.ThreeTuple;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;

public class TimingHandler
extends Handler {
    public static final int MESSAGE_COUNT_TIME = 0;
    public static final int MESSAGE_COUNT_DOWN = 1;
    public static final int MESSAGE_SEND_TIME = 2;
    public static final int MESSAGE_STOP_COUNT_DOWN_TIME = 3;
    public static final int MESSAGE_CHILD_TIME_RUN_OUT = 4;
    public static final int MESSAGE_LOGOUT = 5;
    public static final int COUNT_TIME_PERIOD = 120000;
    public static final int COUNT_DOWN_PERIOD = 1000;
    private final InteractiveOperation operation;

    public TimingHandler(Looper looper, InteractiveOperation operation) {
        super(looper);
        this.operation = operation;
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        try {
            switch (msg.what) {
                case 0: {
                    this.operation.countTime();
                    AntiAddictionLogger.d("MESSAGE_COUNT_TIME:120000");
                    this.sendMessageDelayed(Message.obtain((Message)msg), 120000L);
                    break;
                }
                case 1: {
                    ThreeTuple tuple = (ThreeTuple)msg.obj;
                    boolean finished = this.operation.countDown((String)tuple.firstParam, (String)tuple.secondParam, (Integer)tuple.thirdParam);
                    AntiAddictionLogger.d("MESSAGE_COUNT_DOWN:strictType:" + (String)tuple.firstParam + "," + (String)tuple.secondParam + "," + tuple.thirdParam + ":" + finished);
                    if (finished) break;
                    this.sendMessageDelayed(Message.obtain((Message)msg), 1000L);
                    break;
                }
                case 2: {
                    this.operation.updateServerTime();
                    break;
                }
                case 3: {
                    this.operation.stopCountDownTimerAndUpdateServerTime();
                    break;
                }
                case 4: {
                    int strictType = (Integer)msg.obj;
                    AntiAddictionLogger.d("MESSAGE_CHILD_TIME_RUN_OUT:strictType" + strictType);
                    this.operation.childTimeRunOut(strictType);
                    break;
                }
                case 5: {
                    this.operation.logout();
                }
            }
        }
        catch (Exception e) {
            AntiAddictionLogger.e("TransactionHandler handleMessage error");
            AntiAddictionLogger.printStackTrace(e);
        }
        catch (Throwable throwable) {
            AntiAddictionLogger.printStackTrace(throwable);
        }
    }

    public static interface InteractiveOperation {
        public void countTime();

        public boolean countDown(String var1, String var2, int var3);

        public void updateServerTime();

        public void stopCountDownTimerAndUpdateServerTime();

        public void childTimeRunOut(int var1) throws Throwable;

        public void logout();
    }
}

