/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.reactor;

import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.exceptions.Exceptions;
import com.tapsdk.antiaddiction.reactor.exceptions.OnErrorFailedException;
import com.tapsdk.antiaddiction.reactor.functions.Action0;
import com.tapsdk.antiaddiction.reactor.functions.Action1;
import com.tapsdk.antiaddiction.reactor.functions.Actions;
import com.tapsdk.antiaddiction.reactor.functions.Func1;
import com.tapsdk.antiaddiction.reactor.internal.operators.EmptyObservableHolder;
import com.tapsdk.antiaddiction.reactor.internal.operators.OnSubscribeLift;
import com.tapsdk.antiaddiction.reactor.internal.operators.OnSubscribeMap;
import com.tapsdk.antiaddiction.reactor.internal.operators.OnSubscribeThrow;
import com.tapsdk.antiaddiction.reactor.internal.operators.OperatorMerge;
import com.tapsdk.antiaddiction.reactor.internal.operators.OperatorObserveOn;
import com.tapsdk.antiaddiction.reactor.internal.operators.OperatorSubscribeOn;
import com.tapsdk.antiaddiction.reactor.observers.SafeSubscriber;
import com.tapsdk.antiaddiction.reactor.operators.OnSubscribeCreate;
import com.tapsdk.antiaddiction.reactor.plugins.RxJavaHooks;
import com.tapsdk.antiaddiction.reactor.schedulers.Scheduler;
import com.tapsdk.antiaddiction.reactor.subscriptions.Subscriptions;
import com.tapsdk.antiaddiction.reactor.util.ActionSubscriber;
import com.tapsdk.antiaddiction.reactor.util.InternalObservableUtils;

public class Observable<T> {
    final OnSubscribe<T> onSubscribe;

    public Observable(OnSubscribe<T> onSubscribe) {
        this.onSubscribe = onSubscribe;
    }

    public static <T> Observable<T> create(OnSubscribe<T> onSubscribe) {
        return new Observable<T>(onSubscribe);
    }

    public final Subscription subscribe(Subscriber<? super T> subscriber) {
        return Observable.subscribe(subscriber, this);
    }

    static <T> Subscription subscribe(Subscriber<? super T> subscriber, Observable<T> observable) {
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber can not be null");
        }
        if (observable.onSubscribe == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        subscriber.onStart();
        if (!(subscriber instanceof SafeSubscriber)) {
            subscriber = new SafeSubscriber<T>(subscriber);
        }
        try {
            RxJavaHooks.onObservableStart(observable, observable.onSubscribe).call(subscriber);
            return RxJavaHooks.onObservableReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (subscriber.isUnsubscribed()) {
                RxJavaHooks.onError(RxJavaHooks.onObservableError(e));
            } else {
                try {
                    subscriber.onError(RxJavaHooks.onObservableError(e));
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    OnErrorFailedException r = new OnErrorFailedException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                    RxJavaHooks.onObservableError(r);
                    throw r;
                }
            }
            return Subscriptions.unsubscribed();
        }
    }

    public final void subscribe() {
        Actions.EmptyAction onNext = Actions.empty();
        Action1<Throwable> onError = InternalObservableUtils.ERROR_NOT_IMPLEMENTED;
        Actions.EmptyAction onCompleted = Actions.empty();
        this.subscribe(new ActionSubscriber(onNext, onError, onCompleted));
    }

    public final void subscribe(Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        Action1<Throwable> onError = InternalObservableUtils.ERROR_NOT_IMPLEMENTED;
        Actions.EmptyAction onCompleted = Actions.empty();
        this.subscribe(new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        Actions.EmptyAction onCompleted = Actions.empty();
        return this.subscribe(new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final void subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onCompleted) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onCompleted == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        this.subscribe(new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final Observable<T> subscribeOn(Scheduler scheduler) {
        return this.subscribeOn(scheduler, !(this.onSubscribe instanceof OnSubscribeCreate));
    }

    public final Observable<T> subscribeOn(Scheduler scheduler, boolean requestOn) {
        return Observable.unsafeCreate(new OperatorSubscribeOn(this, scheduler, requestOn));
    }

    public static <T> Observable<T> unsafeCreate(OnSubscribe<T> f) {
        return new Observable<T>(RxJavaHooks.onCreate(f));
    }

    public final Subscription unsafeSubscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onStart();
            RxJavaHooks.onObservableStart(this, this.onSubscribe).call(subscriber);
            return RxJavaHooks.onObservableReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(RxJavaHooks.onObservableError(e));
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                OnErrorFailedException r = new OnErrorFailedException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                RxJavaHooks.onObservableError(r);
                throw r;
            }
            return Subscriptions.unsubscribed();
        }
    }

    public Observable<T> observeOn(Scheduler scheduler) {
        return this.observeOn(scheduler, 128);
    }

    public final Observable<T> observeOn(Scheduler scheduler, int bufferSize) {
        return this.observeOn(scheduler, false, bufferSize);
    }

    public final Observable<T> observeOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.lift(new OperatorObserveOn(scheduler, delayError, bufferSize));
    }

    public final <R> Observable<R> lift(Operator<? extends R, ? super T> operator) {
        return Observable.unsafeCreate(new OnSubscribeLift<T, R>(this.onSubscribe, operator));
    }

    public static <T> Observable<T> error(Throwable exception) {
        return Observable.unsafeCreate(new OnSubscribeThrow(exception));
    }

    public final <R> Observable<R> flatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(this.map(func));
    }

    public final <R> Observable<R> map(Func1<? super T, ? extends R> func) {
        return Observable.unsafeCreate(new OnSubscribeMap<T, R>(this, func));
    }

    public static <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source) {
        return source.lift(OperatorMerge.instance(false));
    }

    public static <T> Observable<T> empty() {
        return EmptyObservableHolder.instance();
    }

    public static interface Operator<R, T>
    extends Func1<Subscriber<? super R>, Subscriber<? super T>> {
    }

    public static interface OnSubscribe<T>
    extends Action1<Subscriber<? super T>> {
    }
}

