/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.reactor.rxandroid.schedulers;

import android.os.Looper;
import com.tapsdk.antiaddiction.reactor.rxandroid.plugins.RxAndroidPlugins;
import com.tapsdk.antiaddiction.reactor.rxandroid.plugins.RxAndroidSchedulersHook;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.LooperScheduler;
import com.tapsdk.antiaddiction.reactor.schedulers.Scheduler;
import java.util.concurrent.atomic.AtomicReference;

public class AndroidSchedulers {
    private static final AtomicReference<AndroidSchedulers> INSTANCE = new AtomicReference();
    private final Scheduler mainThreadScheduler;

    private static AndroidSchedulers getInstance() {
        AndroidSchedulers current;
        do {
            if ((current = INSTANCE.get()) == null) continue;
            return current;
        } while (!INSTANCE.compareAndSet(null, current = new AndroidSchedulers()));
        return current;
    }

    private AndroidSchedulers() {
        RxAndroidSchedulersHook hook = RxAndroidPlugins.getInstance().getSchedulersHook();
        Scheduler main = hook.getMainThreadScheduler();
        this.mainThreadScheduler = main != null ? main : new LooperScheduler(Looper.getMainLooper());
    }

    public static Scheduler mainThread() {
        return AndroidSchedulers.getInstance().mainThreadScheduler;
    }

    public static Scheduler from(Looper looper) {
        if (looper == null) {
            throw new NullPointerException("looper == null");
        }
        return new LooperScheduler(looper);
    }

    public static void reset() {
        INSTANCE.set(null);
    }
}

