/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.skynet;

import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.RespInterceptor;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tds.gson.JsonObject;

public class NetServerErrorChecker
implements RespInterceptor {
    private String extractErrorMessage(JsonObject dataElement) {
        String result = "";
        try {
            if (dataElement.has("error_description") && dataElement.get("error_description") != null && dataElement.get("error_description").getAsString().length() > 0) {
                result = dataElement.get("error_description").getAsString();
            }
            return result;
        }
        catch (Exception e) {
            System.out.println(e.toString());
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public void invoke(JsonObject jsonElement, int statusCode) {
        int code = 9999;
        if (jsonElement.has("success")) {
            if (!jsonElement.get("success").getAsBoolean()) {
                String message = "";
                if (jsonElement.has("data")) {
                    JsonObject dataElement = jsonElement.getAsJsonObject("data");
                    if (dataElement.has("code")) {
                        code = dataElement.get("code").getAsInt();
                    }
                    message = this.extractErrorMessage(dataElement);
                }
                AntiAddictionLogger.d("net response {code:" + code + ",,message:" + message + ", statusCode:" + statusCode);
                throw new AntiServerException(code, message, statusCode);
            }
            if (statusCode != 200) {
                String message = "";
                if (jsonElement.has("data")) {
                    JsonObject dataElement = jsonElement.getAsJsonObject("data");
                    if (dataElement.has("code")) {
                        code = dataElement.get("code").getAsInt();
                    }
                    message = this.extractErrorMessage(dataElement);
                }
                AntiAddictionLogger.d("net response {code:" + code + ",,message:" + message + ", statusCode:" + statusCode);
                throw new AntiServerException(code, message, statusCode);
            }
        } else {
            throw new AntiServerException(code, "illegal response", statusCode);
        }
    }
}

