/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson;

import com.tapsdk.antiaddiction.skynet.okhttp3.RequestBody;
import com.tapsdk.antiaddiction.skynet.okhttp3.ResponseBody;
import com.tapsdk.antiaddiction.skynet.retrofit2.Converter;
import com.tapsdk.antiaddiction.skynet.retrofit2.Retrofit;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.RespInterceptor;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.StringResponseBodyConverter;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson.GsonRequestBodyConverter;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.converter.gson.GsonResponseBodyConverter;
import com.tds.gson.Gson;
import com.tds.gson.TypeAdapter;
import com.tds.gson.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class GsonConverterFactory
extends Converter.Factory {
    private final Gson gson;
    private final List<? extends RespInterceptor> interceptorList;

    public static GsonConverterFactory create(List<? extends RespInterceptor> interceptorList) {
        return GsonConverterFactory.create(new Gson(), interceptorList);
    }

    public static GsonConverterFactory create(Gson gson, List<? extends RespInterceptor> interceptorList) {
        if (gson == null) {
            throw new NullPointerException("gson == null");
        }
        return new GsonConverterFactory(gson, interceptorList);
    }

    private GsonConverterFactory(Gson gson) {
        this.gson = gson;
        this.interceptorList = new ArrayList<RespInterceptor>();
    }

    private GsonConverterFactory(Gson gson, List<? extends RespInterceptor> interceptors) {
        this.gson = gson;
        this.interceptorList = interceptors == null ? new ArrayList<RespInterceptor>() : interceptors;
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        if (type.equals(String.class)) {
            return new StringResponseBodyConverter();
        }
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonResponseBodyConverter(this.gson, adapter, this.interceptorList);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        TypeAdapter adapter = this.gson.getAdapter(TypeToken.get((Type)type));
        return new GsonRequestBodyConverter(this.gson, adapter);
    }
}

