/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava;

import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.schedulers.Scheduler;
import com.tapsdk.antiaddiction.skynet.retrofit2.Call;
import com.tapsdk.antiaddiction.skynet.retrofit2.CallAdapter;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.BodyOnSubscribe;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.CallEnqueueOnSubscribe;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.CallExecuteOnSubscribe;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.Result;
import com.tapsdk.antiaddiction.skynet.retrofit2.adapter.rxjava.ResultOnSubscribe;
import java.lang.reflect.Type;

final class RxJavaCallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;

    RxJavaCallAdapter(Type responseType, Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
    }

    @Override
    public Type responseType() {
        return this.responseType;
    }

    @Override
    public Object adapt(Call<R> call) {
        Observable.OnSubscribe<Response<R>> callFunc;
        Observable.OnSubscribe<Response<R>> onSubscribe = callFunc = this.isAsync ? new CallEnqueueOnSubscribe<R>(call) : new CallExecuteOnSubscribe<R>(call);
        Observable.OnSubscribe<Result<Object>> func = this.isResult ? new ResultOnSubscribe(callFunc) : (this.isBody ? new BodyOnSubscribe(callFunc) : callFunc);
        Observable observable = Observable.create(func);
        if (this.scheduler != null) {
            observable = observable.subscribeOn(this.scheduler);
        }
        return observable;
    }
}

