/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.entities;

import android.app.Activity;
import android.content.Context;
import com.tds.common.entities.Pair;
import com.tds.common.entities.TapBillboardConfig;
import com.tds.common.entities.TapDBConfig;
import com.tds.common.entities.TapPaymentConfig;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;

public class TapConfig {
    public final String clientId;
    public final String clientToken;
    public final String serverUrl;
    public final int regionType;
    public final Context appContext;
    public TapDBConfig tapDBConfig;
    public TapPaymentConfig tapPaymentConfig;
    public TapBillboardConfig tapBillboardConfig;

    public TapConfig(Builder builder) {
        this.clientId = builder.clientId;
        this.clientToken = builder.clientToken;
        this.serverUrl = builder.serverUrl;
        this.regionType = builder.regionType;
        this.appContext = builder.appContext;
        this.tapDBConfig = builder.tapDBConfig == null ? new TapDBConfig() : builder.tapDBConfig;
        this.tapPaymentConfig = builder.tapPaymentConfig == null ? new TapPaymentConfig.Builder().withLanguage("zh_CN").withRegionId("CN").build() : builder.tapPaymentConfig;
        this.tapBillboardConfig = builder.tapBillboardConfig == null ? new TapBillboardConfig.Builder().withDimensionSet(new HashSet<Pair<String, String>>()).build() : builder.tapBillboardConfig;
        this.tapDBConfig = builder.tapDBConfig;
    }

    public static TapConfig constructorTapConfig(Activity activity, String config) {
        try {
            JSONObject jsonObject = new JSONObject(config);
            JSONObject dbJsonObject = jsonObject.optJSONObject("dbConfig");
            String channel = dbJsonObject != null ? dbJsonObject.optString("channel") : null;
            String gameVersion = dbJsonObject != null ? dbJsonObject.optString("gameVersion") : null;
            boolean enable = dbJsonObject == null || dbJsonObject.optBoolean("enable", true);
            TapDBConfig dbConfig = new TapDBConfig();
            dbConfig.setEnable(enable);
            dbConfig.setChannel(channel);
            dbConfig.setGameVersion(gameVersion);
            return new Builder().withAppContext((Context)activity).withClientId(jsonObject.optString("clientID")).withClientToken(jsonObject.optString("clientToken")).withRegionType(jsonObject.optBoolean("isCN") ? 0 : 1).withTapDBConfig(dbConfig).build();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        return "TapConfig{clientId='" + this.clientId + '\'' + ", clientToken='" + this.clientToken + '\'' + ", serverUrl='" + this.serverUrl + '\'' + ", regionType=" + this.regionType + ", appContext=" + this.appContext + ", tapDBConfig=" + this.tapDBConfig.toString() + '}';
    }

    public static class Builder {
        private String clientId;
        private int regionType = 0;
        private Context appContext;
        private String clientToken;
        private String serverUrl;
        private TapDBConfig tapDBConfig = null;
        private TapPaymentConfig tapPaymentConfig = null;
        private TapBillboardConfig tapBillboardConfig = null;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withClientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public Builder withServerUrl(String serverUrl) {
            this.serverUrl = serverUrl;
            return this;
        }

        public Builder withRegionType(int regionType) {
            this.regionType = regionType;
            return this;
        }

        public Builder withAppContext(Context context) {
            this.appContext = context.getApplicationContext();
            return this;
        }

        public Builder withTapDBConfig(TapDBConfig tapDBConfig) {
            this.tapDBConfig = tapDBConfig;
            return this;
        }

        public Builder withTapPaymentConfig(TapPaymentConfig tapPaymentConfig) {
            this.tapPaymentConfig = tapPaymentConfig;
            return this;
        }

        public Builder withBillboardConfig(TapBillboardConfig tapBillboardConfig) {
            this.tapBillboardConfig = tapBillboardConfig;
            return this;
        }

        public TapConfig build() {
            return new TapConfig(this);
        }
    }
}

