/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.isc;

import android.text.TextUtils;
import com.tds.common.isc.IscException;
import com.tds.common.isc.IscService;
import com.tds.common.isc.Service;
import com.tds.common.log.Logger;
import java.util.HashMap;
import java.util.Map;

public final class IscServiceManager {
    static final Logger LOG = Logger.getCommonLogger();
    static final Map<String, Class<?>> map = new HashMap();

    private IscServiceManager() {
    }

    public static void register(Class<?> clazz) {
        IscService annotation = clazz.getAnnotation(IscService.class);
        if (annotation == null) {
            LOG.e("Isc service class must be annotated with @IscService");
        } else {
            String serviceName = annotation.value();
            if (TextUtils.isEmpty((CharSequence)serviceName)) {
                LOG.e("Isc service name cannot be null or empty");
            } else {
                LOG.i("register isc service " + serviceName + " " + clazz.getName());
                map.put(serviceName, clazz);
            }
        }
    }

    public static void unregister(Class<?> clazz) {
        String serviceName;
        IscService annotation = clazz.getAnnotation(IscService.class);
        if (annotation != null && !TextUtils.isEmpty((CharSequence)(serviceName = annotation.value()))) {
            LOG.i("unregister isc service " + serviceName);
            map.remove(serviceName);
        }
    }

    public static boolean hasService(String name) {
        return map.containsKey(name);
    }

    public static boolean hasMethod(String serviceName, String method) {
        try {
            return IscServiceManager.service(serviceName).hasMethod(method);
        }
        catch (IscException e) {
            return false;
        }
    }

    public static Service service(String name) throws IscException {
        Class<?> clazz = map.get(name);
        if (clazz == null) {
            throw new IscException(name + " service not registered");
        }
        return new Service(clazz);
    }
}

