/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.net;

import android.text.TextUtils;
import com.tds.common.net.TDSNetInterceptor;
import com.tds.common.net.TdsHttp;
import com.tds.common.net.exception.ServerException;
import com.tds.common.net.json.JsonUtil;
import com.tds.common.net.json.TypeRef;
import com.tds.common.net.util.HttpUtil;
import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public class TdsApiClient {
    private String baseUrl;
    private String userAgent;
    private TdsHttp.Client tdsClient;

    private TdsApiClient(Builder builder) {
        this.baseUrl = builder.baseUrl;
        this.userAgent = builder.userAgent;
        this.tdsClient = builder.tdsClient;
    }

    public <T> T get(Class<T> clazz, String url) throws IOException, JSONException, ServerException {
        return this.get(clazz, url, null);
    }

    public <T> T get(Class<T> clazz, String url, Map<String, String> queries) throws IOException, JSONException, ServerException {
        return this.get(clazz, url, queries, null);
    }

    public <T> T get(Class<T> clazz, String url, Map<String, String> queries, Map<String, String> headers) throws IOException, JSONException, ServerException {
        String json = this.get(url, queries, headers);
        return JsonUtil.parse(json, clazz);
    }

    public <T> T get(TypeRef<T> typeRef, String url) throws IOException, JSONException, ServerException {
        return this.get(typeRef, url, null);
    }

    public <T> T get(TypeRef<T> typeRef, String url, Map<String, String> queries) throws IOException, JSONException, ServerException {
        return this.get(typeRef, url, queries, null);
    }

    public <T> T get(TypeRef<T> typeRef, String url, Map<String, String> queries, Map<String, String> headers) throws IOException, JSONException, ServerException {
        String json = this.get(url, queries, headers);
        return JsonUtil.parse(json, typeRef);
    }

    public String get(String url) throws IOException, ServerException {
        return this.get(url, null);
    }

    public String get(String url, Map<String, String> queries) throws IOException, ServerException {
        return this.get(url, queries, null);
    }

    public String get(String url, Map<String, String> queries, Map<String, String> headers) throws IOException, ServerException {
        return this.request(url, queries, headers, "GET", null);
    }

    public <T> Observable<T> getAsync(Class<T> clazz, String url) {
        return this.getAsync(clazz, url, null);
    }

    public <T> Observable<T> getAsync(Class<T> clazz, String url, Map<String, String> queries) {
        return this.getAsync(clazz, url, queries, null);
    }

    public <T> Observable<T> getAsync(final Class<T> clazz, final String url, final Map<String, String> queries, final Map<String, String> headers) {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.get(clazz, url, (Map<String, String>)queries, (Map<String, String>)headers));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public <T> Observable<T> getAsync(TypeRef<T> typeRef, String url) {
        return this.getAsync(typeRef, url, null);
    }

    public <T> Observable<T> getAsync(TypeRef<T> typeRef, String url, Map<String, String> queries) {
        return this.getAsync(typeRef, url, queries, null);
    }

    public <T> Observable<T> getAsync(final TypeRef<T> typeRef, final String url, final Map<String, String> queries, final Map<String, String> headers) {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.get(typeRef, url, (Map<String, String>)queries, (Map<String, String>)headers));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public Observable<String> getAsync(String url) {
        return this.getAsync(url, null);
    }

    public Observable<String> getAsync(String url, Map<String, String> queries) {
        return this.getAsync(url, queries, null);
    }

    public Observable<String> getAsync(final String url, final Map<String, String> queries, final Map<String, String> headers) {
        return Observable.create(new Observable.OnSubscribe<String>(){

            @Override
            public void call(Subscriber<? super String> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.get(url, queries, (Map<String, String>)headers));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public String post(String url, JSONObject body) throws IOException, ServerException {
        return this.request(url, null, null, "POST", body);
    }

    public String post(String url, Map<String, String> queries, Map<String, String> headers, JSONObject body) throws IOException, ServerException {
        return this.request(url, queries, headers, "POST", body);
    }

    public <T> T post(Class<T> clazz, String url, JSONObject body) throws IOException, JSONException, ServerException {
        return this.post(clazz, url, null, null, body);
    }

    public <T> T post(Class<T> clazz, String url, Map<String, String> queries, Map<String, String> headers, JSONObject body) throws IOException, JSONException, ServerException {
        String json = this.post(url, queries, headers, body);
        return JsonUtil.parse(json, clazz);
    }

    public <T> T post(TypeRef<T> typeRef, String url, JSONObject body) throws IOException, JSONException, ServerException {
        return this.post(typeRef, url, null, null, body);
    }

    public <T> T post(TypeRef<T> typeRef, String url, Map<String, String> queries, Map<String, String> headers, JSONObject body) throws IOException, JSONException, ServerException {
        String json = this.post(url, queries, headers, body);
        return JsonUtil.parse(json, typeRef);
    }

    public Observable<String> postAsync(String url, JSONObject body) {
        return this.postAsync(url, null, null, body);
    }

    public Observable<String> postAsync(final String url, final Map<String, String> queries, final Map<String, String> headers, final JSONObject body) {
        return Observable.create(new Observable.OnSubscribe<String>(){

            @Override
            public void call(Subscriber<? super String> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.post(url, queries, headers, body));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public <T> Observable<T> postAsync(Class<T> clazz, String url, JSONObject body) {
        return this.postAsync(clazz, url, null, null, body);
    }

    public <T> Observable<T> postAsync(final Class<T> clazz, final String url, final Map<String, String> queries, final Map<String, String> headers, final JSONObject body) {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.post(clazz, url, (Map<String, String>)queries, (Map<String, String>)headers, body));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public <T> Observable<T> postAsync(TypeRef<T> typeRef, String url, JSONObject body) {
        return this.postAsync(typeRef, url, null, null, body);
    }

    public <T> Observable<T> postAsync(final TypeRef<T> typeRef, final String url, final Map<String, String> queries, final Map<String, String> headers, final JSONObject body) {
        return Observable.create(new Observable.OnSubscribe<T>(){

            @Override
            public void call(Subscriber<? super T> subscriber) {
                try {
                    subscriber.onNext(TdsApiClient.this.post(typeRef, url, (Map<String, String>)queries, (Map<String, String>)headers, body));
                }
                catch (Exception e) {
                    subscriber.onError(e);
                }
                finally {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public boolean postProtoBuff(String url, Map<String, String> queries, Map<String, String> headers, byte[] bytes) throws IOException {
        url = HttpUtil.buildUrl(this.baseUrl + url, queries);
        TdsHttp.Request.Builder requestBuilder = new TdsHttp.Request.Builder().url(url);
        if (headers != null) {
            requestBuilder.addHeaders(headers);
        }
        if (bytes == null) {
            requestBuilder.method("POST", null);
        } else {
            requestBuilder.method("POST", TdsHttp.RequestBody.createProtoBuffBody(bytes));
        }
        TdsHttp.Response response = this.tdsClient.newCall(requestBuilder.build()).execute();
        return response.isSuccessful();
    }

    private String request(String url, Map<String, String> queries, Map<String, String> headers, String method, JSONObject body) throws IOException, ServerException {
        url = HttpUtil.buildUrl(this.baseUrl + url, queries);
        TdsHttp.Request.Builder requestBuilder = new TdsHttp.Request.Builder().url(url);
        if (headers != null) {
            requestBuilder.addHeaders(headers);
        }
        if (body == null) {
            requestBuilder.method(method, null);
        } else if (headers != null && !TextUtils.isEmpty((CharSequence)headers.get("Content-Type"))) {
            if (Objects.requireNonNull(headers.get("Content-Type")).contains("application/x-www-form-urlencoded")) {
                TdsHttp.FormBody.Builder formBodyBuilder = new TdsHttp.FormBody.Builder();
                try {
                    Map<String, Object> requestBodyMap = JsonUtil.toMap(body);
                    for (Map.Entry<String, Object> entry : requestBodyMap.entrySet()) {
                        if (entry.getValue() == null || TextUtils.isEmpty((CharSequence)entry.getValue().toString())) continue;
                        formBodyBuilder.add(entry.getKey(), entry.getValue().toString());
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                requestBuilder.method(method, formBodyBuilder.build());
            } else {
                requestBuilder.method(method, TdsHttp.RequestBody.create(headers.get("Content-Type"), body.toString()));
            }
        } else {
            requestBuilder.method(method, TdsHttp.RequestBody.createJsonBody(body.toString()));
        }
        try {
            TdsHttp.Response response = this.tdsClient.newCall(requestBuilder.build()).execute();
            if (this.tdsClient.eventListener != null) {
                this.tdsClient.eventListener.callEnd(this.baseUrl);
            }
            if (response.isSuccessful()) {
                return response.body().string();
            }
            TDSNetInterceptor.interceptWithContent(response.code(), response.message, response.body().string());
            throw new ServerException(response.code(), response.message(), response.body().string());
        }
        catch (Error | Exception e) {
            if (this.tdsClient.eventListener != null) {
                this.tdsClient.eventListener.callFailed(this.baseUrl, new IOException(e));
            }
            throw e;
        }
    }

    public static class Builder {
        private String baseUrl;
        private String userAgent;
        private TdsHttp.Client tdsClient;

        public Builder() {
        }

        Builder(TdsApiClient tdsApiClient) {
            this.baseUrl = tdsApiClient.baseUrl;
            this.userAgent = tdsApiClient.userAgent;
            this.tdsClient = tdsApiClient.tdsClient;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder tdsClient(TdsHttp.Client tdsClient) {
            this.tdsClient = tdsClient;
            return this;
        }

        public TdsApiClient build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("baseUrl required");
            }
            return new TdsApiClient(this);
        }
    }
}

