/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.notch.phone;

import android.os.Build;
import android.view.Window;
import com.tds.common.notch.core.AbsNotchScreenSupport;
import java.lang.reflect.Method;

public class HuaWeiNotchScreen
extends AbsNotchScreenSupport {
    private static final String TAG = HuaWeiNotchScreen.class.getSimpleName();
    private static final String DISPLAY_NOTCH_STATUS = "display_notch_status";

    @Override
    public boolean isNotchScreen(Window window) {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        boolean isNotchScreen = false;
        try {
            ClassLoader cl = window.getContext().getClassLoader();
            Class<?> hwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = hwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            isNotchScreen = (Boolean)get.invoke(hwNotchSizeUtil, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isNotchScreen;
    }

    @Override
    public int getNotchHeight(Window window) {
        if (Build.VERSION.SDK_INT < 26) {
            return 0;
        }
        if (!this.isNotchScreen(window)) {
            return 0;
        }
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = window.getContext().getClassLoader();
            Class<?> hwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = hwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(hwNotchSizeUtil, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret[1];
    }
}

