/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.notch.phone;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.view.Window;
import com.tds.common.notch.core.AbsNotchScreenSupport;
import com.tds.common.notch.helper.NotchStatusBarUtils;
import com.tds.common.notch.helper.SystemProperties;

public class MiuiNotchScreen
extends AbsNotchScreenSupport {
    @Override
    public boolean isNotchScreen(Window window) {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        return "1".equals(SystemProperties.getInstance().get("ro.miui.notch"));
    }

    @Override
    public int getNotchHeight(Window window) {
        if (Build.VERSION.SDK_INT < 26) {
            return 0;
        }
        if (!this.isNotchScreen(window)) {
            return 0;
        }
        int result = 0;
        if (window == null) {
            return 0;
        }
        Context context = window.getContext();
        result = this.isHideNotch(window.getContext()) ? NotchStatusBarUtils.getStatusBarHeight(context) : this.getRealNotchHeight(context);
        return result;
    }

    private int getRealNotchHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private boolean isHideNotch(Context activity) {
        return Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"force_black", (int)0) == 1;
    }
}

