/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor;

import com.tds.common.reactor.Observer;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.Subscription;
import com.tds.common.reactor.exceptions.Exceptions;
import com.tds.common.reactor.exceptions.OnErrorFailedException;
import com.tds.common.reactor.functions.Action0;
import com.tds.common.reactor.functions.Action1;
import com.tds.common.reactor.functions.Actions;
import com.tds.common.reactor.functions.Func1;
import com.tds.common.reactor.internal.operators.EmptyObservableHolder;
import com.tds.common.reactor.internal.operators.OnSubscribeDoOnEach;
import com.tds.common.reactor.internal.operators.OnSubscribeFilter;
import com.tds.common.reactor.internal.operators.OnSubscribeFromArray;
import com.tds.common.reactor.internal.operators.OnSubscribeFromIterable;
import com.tds.common.reactor.internal.operators.OnSubscribeLift;
import com.tds.common.reactor.internal.operators.OnSubscribeMap;
import com.tds.common.reactor.internal.operators.OnSubscribeThrow;
import com.tds.common.reactor.internal.operators.OnSubscribeTimeoutTimedWithFallback;
import com.tds.common.reactor.internal.operators.OperatorDebounceWithSelector;
import com.tds.common.reactor.internal.operators.OperatorMerge;
import com.tds.common.reactor.internal.operators.OperatorObserveOn;
import com.tds.common.reactor.internal.operators.OperatorOnErrorResumeNextViaFunction;
import com.tds.common.reactor.internal.operators.OperatorSubscribeOn;
import com.tds.common.reactor.internal.operators.OperatorToObservableList;
import com.tds.common.reactor.internal.util.ActionObserver;
import com.tds.common.reactor.internal.util.ObserverSubscriber;
import com.tds.common.reactor.internal.util.ScalarSynchronousObservable;
import com.tds.common.reactor.observers.SafeSubscriber;
import com.tds.common.reactor.operators.OnSubscribeCreate;
import com.tds.common.reactor.plugins.RxJavaHooks;
import com.tds.common.reactor.schedulers.Scheduler;
import com.tds.common.reactor.schedulers.Schedulers;
import com.tds.common.reactor.subscriptions.Subscriptions;
import com.tds.common.reactor.util.ActionSubscriber;
import com.tds.common.reactor.util.InternalObservableUtils;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Observable<T> {
    final OnSubscribe<T> onSubscribe;

    protected Observable(OnSubscribe<T> onSubscribe) {
        this.onSubscribe = onSubscribe;
    }

    public static <T> Observable<T> create(OnSubscribe<T> onSubscribe) {
        return new Observable<T>(onSubscribe);
    }

    public final Subscription subscribe(Subscriber<? super T> subscriber) {
        return Observable.subscribe(subscriber, this);
    }

    static <T> Subscription subscribe(Subscriber<? super T> subscriber, Observable<T> observable) {
        if (subscriber == null) {
            throw new IllegalArgumentException("subscriber can not be null");
        }
        if (observable.onSubscribe == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        subscriber.onStart();
        if (!(subscriber instanceof SafeSubscriber)) {
            subscriber = new SafeSubscriber<T>(subscriber);
        }
        try {
            RxJavaHooks.onObservableStart(observable, observable.onSubscribe).call(subscriber);
            return RxJavaHooks.onObservableReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            if (subscriber.isUnsubscribed()) {
                RxJavaHooks.onError(RxJavaHooks.onObservableError(e));
            } else {
                try {
                    subscriber.onError(RxJavaHooks.onObservableError(e));
                }
                catch (Throwable e2) {
                    Exceptions.throwIfFatal(e2);
                    OnErrorFailedException r = new OnErrorFailedException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                    RxJavaHooks.onObservableError(r);
                    throw r;
                }
            }
            return Subscriptions.unsubscribed();
        }
    }

    public final Subscription subscribe() {
        Actions.EmptyAction onNext = Actions.empty();
        Action1<Throwable> onError = InternalObservableUtils.ERROR_NOT_IMPLEMENTED;
        Actions.EmptyAction onCompleted = Actions.empty();
        return this.subscribe(new ActionSubscriber(onNext, onError, onCompleted));
    }

    public final Subscription subscribe(Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        Action1<Throwable> onError = InternalObservableUtils.ERROR_NOT_IMPLEMENTED;
        Actions.EmptyAction onCompleted = Actions.empty();
        return this.subscribe((Subscriber<? super T>)new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        Actions.EmptyAction onCompleted = Actions.empty();
        return this.subscribe((Subscriber<? super T>)new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onCompleted) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onCompleted == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return this.subscribe((Subscriber<? super T>)new ActionSubscriber<T>(onNext, onError, onCompleted));
    }

    public final Subscription subscribe(Observer<? super T> observer) {
        if (observer instanceof Subscriber) {
            return this.subscribe((Subscriber)observer);
        }
        if (observer == null) {
            throw new NullPointerException("observer is null");
        }
        return this.subscribe((Subscriber<? super T>)new ObserverSubscriber<T>(observer));
    }

    public final Observable<T> subscribeOn(Scheduler scheduler) {
        return this.subscribeOn(scheduler, !(this.onSubscribe instanceof OnSubscribeCreate));
    }

    public final Observable<T> subscribeOn(Scheduler scheduler, boolean requestOn) {
        return Observable.unsafeCreate(new OperatorSubscribeOn(this, scheduler, requestOn));
    }

    public static <T> Observable<T> unsafeCreate(OnSubscribe<T> f) {
        return new Observable<T>(RxJavaHooks.onCreate(f));
    }

    public final Subscription unsafeSubscribe(Subscriber<? super T> subscriber) {
        try {
            subscriber.onStart();
            RxJavaHooks.onObservableStart(this, this.onSubscribe).call(subscriber);
            return RxJavaHooks.onObservableReturn(subscriber);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                subscriber.onError(RxJavaHooks.onObservableError(e));
            }
            catch (Throwable e2) {
                Exceptions.throwIfFatal(e2);
                OnErrorFailedException r = new OnErrorFailedException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                RxJavaHooks.onObservableError(r);
                throw r;
            }
            return Subscriptions.unsubscribed();
        }
    }

    public Observable<T> observeOn(Scheduler scheduler) {
        return this.observeOn(scheduler, 128);
    }

    public final Observable<T> observeOn(Scheduler scheduler, int bufferSize) {
        return this.observeOn(scheduler, false, bufferSize);
    }

    public final Observable<T> observeOn(Scheduler scheduler, boolean delayError, int bufferSize) {
        return this.lift(new OperatorObserveOn(scheduler, delayError, bufferSize));
    }

    public final <R> Observable<R> lift(Operator<? extends R, ? super T> operator) {
        return Observable.unsafeCreate(new OnSubscribeLift<T, R>(this.onSubscribe, operator));
    }

    public final <R> Observable<R> map(Func1<? super T, ? extends R> func) {
        return Observable.unsafeCreate(new OnSubscribeMap<T, R>(this, func));
    }

    public final <R> Observable<R> flatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.merge(this.map(func));
    }

    public static <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source) {
        return source.lift(OperatorMerge.instance(false));
    }

    public static <T> Observable<T> empty() {
        return EmptyObservableHolder.instance();
    }

    public static <T> Observable<T> just(T value) {
        return ScalarSynchronousObservable.create(value);
    }

    public static <T> Observable<T> just(T t1, T t2) {
        return Observable.from(new Object[]{t1, t2});
    }

    public static <T> Observable<T> just(T t1, T t2, T t3) {
        return Observable.from(new Object[]{t1, t2, t3});
    }

    public static <T> Observable<T> just(T t1, T t2, T t3, T t4) {
        return Observable.from(new Object[]{t1, t2, t3, t4});
    }

    public static <T> Observable<T> just(T t1, T t2, T t3, T t4, T t5) {
        return Observable.from(new Object[]{t1, t2, t3, t4, t5});
    }

    public static <T> Observable<T> from(T[] array) {
        int n = array.length;
        if (n == 0) {
            return Observable.empty();
        }
        if (n == 1) {
            return Observable.just(array[0]);
        }
        return Observable.unsafeCreate(new OnSubscribeFromArray<T>(array));
    }

    public static <T> Observable<T> from(Iterable<? extends T> iterable) {
        return Observable.unsafeCreate(new OnSubscribeFromIterable<T>(iterable));
    }

    public final Observable<T> filter(Func1<? super T, Boolean> predicate) {
        return Observable.unsafeCreate(new OnSubscribeFilter<T>(this, predicate));
    }

    public final Observable<T> onErrorResumeNext(Func1<? super Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return this.lift(new OperatorOnErrorResumeNextViaFunction(resumeFunction));
    }

    public static <T> Observable<T> error(Throwable exception) {
        return Observable.unsafeCreate(new OnSubscribeThrow(exception));
    }

    public final Observable<T> doOnError(Action1<? super Throwable> onError) {
        Actions.EmptyAction onNext = Actions.empty();
        Actions.EmptyAction onCompleted = Actions.empty();
        ActionObserver observer = new ActionObserver(onNext, onError, onCompleted);
        return Observable.unsafeCreate(new OnSubscribeDoOnEach(this, observer));
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit) {
        return this.timeout(timeout, timeUnit, null, Schedulers.computation());
    }

    public final Observable<T> timeout(long timeout, TimeUnit timeUnit, Observable<? extends T> other, Scheduler scheduler) {
        return Observable.unsafeCreate(new OnSubscribeTimeoutTimedWithFallback<T>(this, timeout, timeUnit, scheduler, other));
    }

    public final <U> Observable<T> debounce(Func1<? super T, ? extends Observable<U>> debounceSelector) {
        return this.lift(new OperatorDebounceWithSelector(debounceSelector));
    }

    public final Observable<List<T>> toList() {
        return this.lift(OperatorToObservableList.instance());
    }

    public static interface Operator<R, T>
    extends Func1<Subscriber<? super R>, Subscriber<? super T>> {
    }

    public static interface OnSubscribe<T>
    extends Action1<Subscriber<? super T>> {
    }
}

