/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.schedulers;

import com.tds.common.reactor.internal.schedulers.ExecutorScheduler;
import com.tds.common.reactor.plugins.RxJavaHooks;
import com.tds.common.reactor.plugins.RxJavaPlugins;
import com.tds.common.reactor.plugins.RxJavaSchedulersHook;
import com.tds.common.reactor.schedulers.Scheduler;
import com.tds.common.reactor.schedulers.SchedulerLifecycle;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

public class Schedulers {
    private final Scheduler computationScheduler;
    private final Scheduler ioScheduler;
    private final Scheduler newThreadScheduler;
    private static final AtomicReference<Schedulers> INSTANCE = new AtomicReference();

    private static Schedulers getInstance() {
        Schedulers current;
        while ((current = INSTANCE.get()) == null) {
            current = new Schedulers();
            if (INSTANCE.compareAndSet(null, current)) {
                return current;
            }
            current.shutdownInstance();
        }
        return current;
    }

    private Schedulers() {
        RxJavaSchedulersHook hook = RxJavaPlugins.getInstance().getSchedulersHook();
        Scheduler c = hook.getComputationScheduler();
        this.computationScheduler = c != null ? c : RxJavaSchedulersHook.createComputationScheduler();
        Scheduler io = hook.getIOScheduler();
        this.ioScheduler = io != null ? io : RxJavaSchedulersHook.createIoScheduler();
        Scheduler nt = hook.getNewThreadScheduler();
        this.newThreadScheduler = nt != null ? nt : RxJavaSchedulersHook.createNewThreadScheduler();
    }

    public static Scheduler newThread() {
        return RxJavaHooks.onNewThreadScheduler(Schedulers.getInstance().newThreadScheduler);
    }

    public static Scheduler computation() {
        return RxJavaHooks.onComputationScheduler(Schedulers.getInstance().computationScheduler);
    }

    public static Scheduler io() {
        return RxJavaHooks.onIOScheduler(Schedulers.getInstance().ioScheduler);
    }

    public static void reset() {
        Schedulers s = INSTANCE.getAndSet(null);
        if (s != null) {
            s.shutdownInstance();
        }
    }

    synchronized void startInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).start();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).start();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).start();
        }
    }

    synchronized void shutdownInstance() {
        if (this.computationScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.computationScheduler)).shutdown();
        }
        if (this.ioScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.ioScheduler)).shutdown();
        }
        if (this.newThreadScheduler instanceof SchedulerLifecycle) {
            ((SchedulerLifecycle)((Object)this.newThreadScheduler)).shutdown();
        }
    }

    public static Scheduler from(Executor executor) {
        return new ExecutorScheduler(executor);
    }
}

