/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.transformer;

import com.tds.common.reactor.Producer;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.transformer.FlowCall;
import java.util.concurrent.atomic.AtomicInteger;

public class FlowArbiter<T>
extends AtomicInteger
implements Producer {
    private static final int STATE_WAITING = 0;
    private static final int STATE_REQUESTED = 1;
    private static final int STATE_HAS_RESPONSE = 2;
    private static final int STATE_TERMINATED = 3;
    private final Subscriber<? super FlowResult<T>> subscriber;
    private final FlowCall<T> call;
    private volatile FlowResult<T> flowResult;

    public FlowArbiter(FlowCall<T> call, Subscriber<? super FlowResult<T>> subscriber) {
        this.subscriber = subscriber;
        this.call = call;
    }

    void emitResponse(FlowResult<T> flowResult) {
        while (true) {
            int state = this.get();
            switch (state) {
                case 0: {
                    this.flowResult = flowResult;
                    if (!this.compareAndSet(0, 1)) break;
                    return;
                }
                case 2: {
                    if (!this.compareAndSet(1, 3)) break;
                    this.deliverResponse(flowResult);
                    return;
                }
            }
        }
    }

    void emitError(Throwable t) {
        this.set(3);
        try {
            this.subscriber.onError(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deliverResponse(FlowResult<T> flowResult) {
        try {
            this.subscriber.onNext(flowResult);
        }
        catch (Exception e) {
            return;
        }
        try {
            this.subscriber.onCompleted();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void request(long amount) {
        if (amount == 0L) {
            return;
        }
        block5: while (true) {
            state = this.get();
            switch (state) {
                case 0: {
                    if (!this.compareAndSet(0, 1)) continue block5;
                    return;
                }
                case 2: {
                    if (this.compareAndSet(2, 3)) ** break;
                    continue block5;
                    this.deliverResponse(this.flowResult);
                    return;
                }
                case 1: 
                case 3: {
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown state: " + state);
    }

    public static class FlowResult<T> {
        public final int code;
        public final T data;

        public FlowResult() {
            this(Integer.MIN_VALUE, null);
        }

        public FlowResult(int code, T data) {
            this.code = code;
            this.data = data;
        }
    }
}

