/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.reactor.transformer;

import com.tds.common.reactor.Observable;
import com.tds.common.reactor.Subscriber;
import com.tds.common.reactor.exceptions.FlowException;
import com.tds.common.reactor.transformer.FlowArbiter;

public class FlowOnSubscribe<T>
implements Observable.OnSubscribe<T> {
    private final Observable.OnSubscribe<FlowArbiter.FlowResult<T>> upstream;

    public FlowOnSubscribe(Observable.OnSubscribe<FlowArbiter.FlowResult<T>> upstream) {
        this.upstream = upstream;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        this.upstream.call((FlowArbiter.FlowResult<FlowOnSubscriber<? super T>>)((Object)new FlowOnSubscriber<T>(subscriber)));
    }

    private static class FlowOnSubscriber<R>
    extends Subscriber<FlowArbiter.FlowResult<R>> {
        private final Subscriber<? super R> subscriber;
        private boolean subscriberTerminated;

        FlowOnSubscriber(Subscriber<? super R> subscriber) {
            super(subscriber);
            this.subscriber = subscriber;
        }

        @Override
        public void onCompleted() {
            if (!this.subscriberTerminated) {
                this.subscriber.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.subscriberTerminated) {
                this.subscriber.onError(e);
            }
        }

        @Override
        public void onNext(FlowArbiter.FlowResult<R> flowResult) {
            if (flowResult.code == 0) {
                this.subscriber.onNext(flowResult.data);
            } else {
                this.subscriberTerminated = true;
                try {
                    this.subscriber.onError(new FlowException(9999, "\u672a\u77e5\u9519\u8bef"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

