/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.tracker;

import android.text.TextUtils;
import com.tds.common.tracker.TdsTrackerConfig;
import com.tds.common.tracker.TdsTrackerHandlerThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class TdsTracker {
    private static final Map<String, TdsTracker> mTagCache = new ConcurrentHashMap<String, TdsTracker>();
    private TdsTrackerConfig tdsTrackerConfig;
    static TdsTrackerHandlerThread sHandlerThread = new TdsTrackerHandlerThread("TdsTracker_Thread");

    TdsTracker() {
    }

    public static TdsTracker getTracker(TdsTrackerConfig trackerConfig) {
        if (trackerConfig.topic.isEmpty()) {
            throw new IllegalArgumentException("topic name empty");
        }
        String name = "";
        if (!TextUtils.isEmpty((CharSequence)trackerConfig.topic)) {
            name = name + trackerConfig.topic;
        }
        if (mTagCache.containsKey(name)) {
            return mTagCache.get(name);
        }
        TdsTracker tdsTracker = new TdsTracker();
        tdsTracker.tdsTrackerConfig = trackerConfig;
        mTagCache.put(trackerConfig.topic, tdsTracker);
        return tdsTracker;
    }

    public static TdsTracker get(int trackerType) {
        return TdsTracker.getTracker(new TdsTrackerConfig.Builder().withTrackerType(trackerType).build(null));
    }

    public static synchronized void initTdsTracker(TdsTrackerConfig trackerConfig) {
        TdsTracker.getTracker(trackerConfig);
    }

    public void track(Map<String, String> logContentsMap) {
        sHandlerThread.write(this.tdsTrackerConfig, logContentsMap);
    }

    static {
        sHandlerThread.start();
    }
}

