/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.utils;

import android.text.TextUtils;
import java.util.Collection;

public class Preconditions {
    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T string) {
        if (TextUtils.isEmpty(string)) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    public static <T extends CharSequence> T checkStringNotEmpty(T string, Object errorMessage) {
        if (TextUtils.isEmpty(string)) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
        return string;
    }

    public static <T extends CharSequence> T checkStringNotExceed256(T string, Object errorMessage) {
        return Preconditions.checkStringNotExceed(256, string, errorMessage);
    }

    public static <T extends CharSequence> T checkStringNotExceed128(T string, Object errorMessage) {
        return Preconditions.checkStringNotExceed(128, string, errorMessage);
    }

    public static <T extends CharSequence> T checkStringNotExceed64(T string, Object errorMessage) {
        return Preconditions.checkStringNotExceed(64, string, errorMessage);
    }

    public static <T extends CharSequence> T checkStringNotExceed8(T string, Object errorMessage) {
        return Preconditions.checkStringNotExceed(8, string, errorMessage);
    }

    public static <T extends CharSequence> T checkStringNotExceed(int upperLimit, T string, Object errorMessage) {
        Preconditions.checkStringNotEmpty(string, "string is empty");
        if (string.length() < upperLimit) {
            return string;
        }
        throw new IllegalArgumentException(String.valueOf(errorMessage));
    }

    public static <T extends CharSequence> T checkStringAndReplace(boolean expression, T string, T newString) {
        if (!expression) {
            return string;
        }
        return newString;
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new NullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> Collection<T> checkCollectionNotEmpty(Collection<T> value, String valueName) {
        if (value == null) {
            throw new NullPointerException(valueName + " must not be null");
        }
        if (value.isEmpty()) {
            throw new IllegalArgumentException(valueName + " is empty");
        }
        return value;
    }

    public static <T extends CharSequence> boolean isEmptyOrExceed8(T string) {
        return Preconditions.isEmptyOrExceed(64, string);
    }

    public static <T extends CharSequence> boolean isEmptyOrExceed64(T string) {
        return Preconditions.isEmptyOrExceed(64, string);
    }

    public static <T extends CharSequence> boolean isEmptyOrExceed128(T string) {
        return Preconditions.isEmptyOrExceed(128, string);
    }

    public static <T extends CharSequence> boolean isEmptyOrExceed256(T string) {
        return Preconditions.isEmptyOrExceed(256, string);
    }

    public static <T extends CharSequence> boolean isEmptyOrExceed(int upperLimit, T string) {
        if (TextUtils.isEmpty(string)) {
            return true;
        }
        return string.length() > upperLimit;
    }
}

