/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.websocket;

import com.tds.common.websocket.TDSWebSocketService;
import com.tds.common.websocket.WebSocketEventListener;
import com.tds.common.websocket.handshake.ServerHandshake;
import com.tds.common.websocket.util.LogUtil;
import java.net.URI;
import java.util.Map;
import java.util.Set;

public class WebSocketClient
extends com.tds.common.websocket.client.WebSocketClient {
    private WebSocketEventListener webClientListener;

    public WebSocketClient(URI serverUri, TDSWebSocketService.WebSocketConfig webSocketConfig, WebSocketEventListener listener) {
        super(serverUri);
        this.webClientListener = listener;
        this.setConnectionLostTimeout(webSocketConfig.connectionTimeout);
        if (webSocketConfig.heads != null) {
            Set<String> keys = webSocketConfig.heads.keySet();
            for (String key : keys) {
                this.addHeader(key, webSocketConfig.heads.get(key));
            }
        }
    }

    public WebSocketClient(URI serverUri, Map<String, String> httpHeaders, WebSocketEventListener listener) {
        super(serverUri, httpHeaders);
        this.webClientListener = listener;
    }

    public void removeEventListener() {
        this.webClientListener = null;
    }

    @Override
    public void onOpen(ServerHandshake handshakedata) {
        LogUtil.logE("---websocket open----");
        if (this.webClientListener != null) {
            this.webClientListener.onOpen();
        }
    }

    @Override
    public void onMessage(String s) {
        LogUtil.logE("websocket message = " + s);
        if (this.webClientListener != null) {
            this.webClientListener.onMessage(s);
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        LogUtil.logE("--websocket close --- code = " + code + " reason = " + reason + " remote = " + remote);
        if (this.webClientListener != null) {
            this.webClientListener.onClose(code, reason, remote);
        }
    }

    @Override
    public void onError(Exception e) {
        LogUtil.logE("websocket error e = " + e.getMessage());
        if (this.webClientListener != null) {
            this.webClientListener.onError(e);
        }
    }
}

