/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.tds.common.widgets.image.ImageTarget;
import com.tds.common.widgets.image.LoadBuilder;
import com.tds.common.widgets.image.TdsImage;

public class NetworkImageView
extends ImageView {
    private String mUrl;
    private int mDefaultImageId;
    private int mErrorImageId;
    private TdsImage mTdsImage;
    private LoadBuilder mLoadBuilder;
    private ImageTarget mImageTarget;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageUrl(String url) {
        if (this.mUrl == null || !this.mUrl.equals(url)) {
            this.mUrl = url;
            if (url != null) {
                this.mTdsImage = TdsImage.get(this.getContext());
                this.mLoadBuilder = this.mTdsImage.load(url);
            }
            this.loadImageIfNecessary();
        }
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    void loadImageIfNecessary() {
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageTarget != null && this.mTdsImage != null) {
                this.mTdsImage.cancelRequest(this.mImageTarget);
            }
            this.setDefaultImageOrNull();
            return;
        }
        this.initImageTarget();
        if (this.mLoadBuilder != null) {
            this.mLoadBuilder.error(this.mErrorImageId).placeholder(this.mDefaultImageId).scale(width, height, this.getScaleType()).into(this.mImageTarget);
        }
    }

    private void resetBitmapSize(Bitmap bitmap) {
        int maxHeight;
        if (bitmap == null) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        int maxWidth = wrapWidth ? 0 : width;
        int n = maxHeight = wrapHeight ? 0 : height;
        if (maxWidth == 0 && maxHeight == 0) {
            this.setImageBitmapInMain(bitmap);
        } else {
            int actualWidth = bitmap.getWidth();
            int actualHeight = bitmap.getHeight();
            int desiredWidth = this.getResizedDimension(maxWidth, maxHeight, actualWidth, actualHeight, this.getScaleType());
            int desiredHeight = this.getResizedDimension(maxHeight, maxWidth, actualHeight, actualWidth, this.getScaleType());
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true);
            this.setImageBitmapInMain(bitmap);
        }
    }

    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary();
    }

    protected void onDetachedFromWindow() {
        if (this.mTdsImage != null && this.mLoadBuilder != null) {
            this.mTdsImage.cancelRequest((Object)this);
            this.setImageBitmap(null);
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    private void initImageTarget() {
        if (this.mImageTarget == null) {
            this.mImageTarget = new ImageTarget(){

                @Override
                public void onSuccess(Bitmap bitmap) {
                    if (bitmap != null) {
                        NetworkImageView.this.setImageBitmapInMain(bitmap);
                    } else {
                        this.onFailure(new RuntimeException("get bitmap from net error"));
                    }
                }

                @Override
                public void onFailure(Throwable throwable) {
                    if (NetworkImageView.this.mErrorImageId > 0) {
                        NetworkImageView.this.setImageResource(NetworkImageView.this.mErrorImageId);
                    }
                }
            };
        }
    }

    private int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary, ImageView.ScaleType scaleType) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            return maxPrimary == 0 ? actualPrimary : maxPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        double ratio = (double)actualSecondary / (double)actualPrimary;
        int resized = maxPrimary;
        if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            if ((double)maxPrimary * ratio < (double)maxSecondary) {
                resized = (int)((double)maxSecondary / ratio);
            }
            return resized;
        }
        if ((double)maxPrimary * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    private void setImageBitmapInMain(final Bitmap bitmap) {
        if (bitmap != null) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    NetworkImageView.this.setImageBitmap(bitmap);
                }
            });
        }
    }
}

