/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.wrapper;

import android.app.Activity;
import android.content.Context;
import com.tds.common.TapCommon;
import com.tds.common.annotation.Keep;
import com.tds.common.bridge.BridgeCallback;
import com.tds.common.bridge.utils.BridgeJsonHelper;
import com.tds.common.entities.TapConfig;
import com.tds.common.localize.LocalizeManager;
import com.tds.common.log.Logger;
import com.tds.common.net.PlatformXUA;
import com.tds.common.net.util.HostReplaceUtil;
import com.tds.common.region.TdsRegionHelper;
import com.tds.common.tracker.TdsTrackerConfig;
import com.tds.common.tracker.TdsTrackerManager;
import com.tds.common.utils.SP;
import com.tds.common.utils.TapGameUtil;
import com.tds.common.wrapper.TDSCommonService;
import com.tds.common.wrapper.TapPropertiesHolder;
import com.tds.common.wrapper.TapPropertiesProxy;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class TDSCommonServiceImpl
implements TDSCommonService {
    private static final String TAG = TDSCommonServiceImpl.class.getSimpleName();
    private Logger logger = Logger.get("common_log");
    public static final String TRACKER_ENDPOINT_IO = "openlog.tap.io";
    public static final String TRACKER_ENDPOINT_DOMESTIC = "openlog.taptap.com";

    @Override
    public void init(Activity activity, String configJSON, String versionName) {
        TapConfig config = TapConfig.constructorTapConfig(activity, configJSON);
        if (config == null) {
            return;
        }
        TapCommon.init(config);
        if (!SP.inited()) {
            SP.initialize((Context)activity);
        }
        try {
            if (config.regionType == 1) {
                this.logger.i("begin init networkTrackerManager");
                TdsTrackerConfig networkTrackerConfig = new TdsTrackerConfig.Builder().withTrackerType(3).withAccessKeyId(config.clientId).withAccessKeySecret(config.clientToken).withEndPoint(TRACKER_ENDPOINT_IO).withProjectName("tds").withLogStore("sdk-network").withSdkVersion(31605001).withSdkVersionName("3.16.5").build(activity.getApplicationContext());
                TdsTrackerManager.registerTracker(networkTrackerConfig);
            }
            this.logger.i("begin init userEventTrackerManager");
            TdsTrackerConfig tapSdkTrackerConfig = new TdsTrackerConfig.Builder().withTrackerType(0).withAccessKeyId(config.clientId).withAccessKeySecret(config.clientToken).withEndPoint(config.regionType == 0 ? TRACKER_ENDPOINT_DOMESTIC : TRACKER_ENDPOINT_IO).withProjectName("tds").withLogStore("sdk-user-event").withSdkVersion(31605001).withSdkVersionName("3.16.5").build(activity.getApplicationContext());
            TdsTrackerManager.registerTracker(tapSdkTrackerConfig);
            this.logger.i("initTrackerManager completed");
        }
        catch (Exception e) {
            this.logger.e("initTrackerManager:" + e.getMessage());
        }
    }

    @Override
    public void setXUA(String json) {
        this.logger.i(TAG, "setXUA:" + json);
        try {
            JSONObject jsonObject = new JSONObject(json);
            HashMap<String, String> params = new HashMap<String, String>(jsonObject.length());
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                params.put(key, jsonObject.optString(key));
            }
            PlatformXUA.getInstance().setXuaMap(params);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setPreferredLanguage(int language) {
        LocalizeManager.changeGameSelectedLanguage(language);
    }

    @Override
    public void getRegionCode(Activity activity, final BridgeCallback callback) {
        this.logger.i(TAG, "getRegionCode");
        TdsRegionHelper.getRegionCode((Context)activity, new TdsRegionHelper.RegionCallback(){

            @Override
            public void onRegion(boolean isMainland) {
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                params.put("isMainland", isMainland);
                callback.onResult(BridgeJsonHelper.object2JsonString(params));
            }
        });
    }

    @Override
    public void isTapTapInstalled(Activity activity, BridgeCallback callback) {
        this.logger.i(TAG, "isTapTapInstalled");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isTapTapInstalled", TapGameUtil.isTapTapInstalled((Context)activity));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void isTapGlobalInstalled(Activity activity, BridgeCallback callback) {
        this.logger.i(TAG, "isTapGlobalInstalled");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isTapGlobalInstalled", TapGameUtil.isTapGlobalInstalled((Context)activity));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void updateGameInTapTap(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i(TAG, "updateGameInTapTap");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("updateGameInTapTap", TapGameUtil.updateGameInTapTap(activity, appId));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void updateGameInTapGlobal(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i(TAG, "updateGameInTapGlobal");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("updateGameInTapGlobal", TapGameUtil.updateGameInTapGlobal(activity, appId));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void openReviewInTapTap(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i(TAG, "openReviewInTapTap");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("openReviewInTapTap", TapGameUtil.openReviewInTapTap(activity, appId));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void openReviewInTapGlobal(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i(TAG, "openReviewInTapGlobal");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("openReviewInTapGlobal", TapGameUtil.openReviewInTapGlobal(activity, appId));
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void addHost(String host, String replaceHost) {
        HostReplaceUtil.getInstance().addReplacedHostPair(host, replaceHost);
    }

    @Override
    public void updateGameAndFailToWebInTapTap(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i("updateGameAndFailToWebInTapTap :" + appId);
        boolean result = TapGameUtil.updateGameAndFailToWebInTapTap(activity, appId);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void updateGameAndFailToWebInTapGlobal(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i("updateGameAndFailToWebInTapGlobal :" + appId);
        boolean result = TapGameUtil.updateGameAndFailToWebInTapGlobal(activity, appId);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void updateGameAndFailToWebInTapTap(Activity activity, String appId, String webUrl, BridgeCallback callback) {
        this.logger.i("updateGameAndFailToWebInTapTap :" + appId);
        boolean result = TapGameUtil.updateGameAndFailToWebInTapTap(activity, appId, webUrl);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void updateGameAndFailToWebInTapGlobal(Activity activity, String appId, String webUrl, BridgeCallback callback) {
        this.logger.i("updateGameAndFailToWebInTapGlobal :" + appId);
        boolean result = TapGameUtil.updateGameAndFailToWebInTapGlobal(activity, appId, webUrl);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void openWebDownloadUrlOfTapTap(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i("openWebDownloadUrlOfTapTap :" + appId);
        boolean result = TapGameUtil.openWebDownloadUrlOfTapTap(activity, appId);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void openWebDownloadUrlOfTapGlobal(Activity activity, String appId, BridgeCallback callback) {
        this.logger.i("openWebDownloadUrlOfTapGlobal :" + appId);
        boolean result = TapGameUtil.openWebDownloadUrlOfTapGlobal(activity, appId);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void openWebDownloadUrl(Activity activity, String url, BridgeCallback callback) {
        this.logger.i("openWebDownloadUrl :" + url);
        boolean result = TapGameUtil.openWebDownloadUrl(activity, url);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>(1);
        params.put("result", result);
        callback.onResult(BridgeJsonHelper.object2JsonString(params));
    }

    @Override
    public void registerProperties(String key, TapPropertiesProxy proxy) {
        this.logger.i(TAG, "registerProperties");
        TapPropertiesHolder.INSTANCE.registerProperties(key, proxy);
    }
}

