/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddictionui.widget;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.Html;
import android.text.Layout;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tapsdk.antiaddiction.AntiAddictionKit;
import com.tapsdk.antiaddiction.Callback;
import com.tapsdk.antiaddiction.entities.IdentificationInfo;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.entities.response.IdentifyState;
import com.tapsdk.antiaddiction.models.IdentifyModel;
import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.Subscription;
import com.tapsdk.antiaddiction.reactor.rxandroid.schedulers.AndroidSchedulers;
import com.tapsdk.antiaddiction.reactor.schedulers.Schedulers;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.UIConfigHelper;
import com.tapsdk.antiaddictionui.R;
import com.tapsdk.antiaddictionui.utils.ActivityUtils;
import com.tapsdk.antiaddictionui.utils.ToastUtils;
import com.tapsdk.antiaddictionui.widget.AbsBaseDialogFragment;

public class DialogGameRealName
extends AbsBaseDialogFragment
implements View.OnClickListener {
    public static final String TAG = "DialogGameRealName";
    private static final int DETAIL_TIPS_MAX_LINE = 3;
    private ImageView ivClose;
    private TextView tvTitle;
    private TextView tvRealNameTips;
    private EditText etUserRealName;
    private EditText etUserIdentification;
    private TextView tvFunctionButton;
    private TextView tvUserAuthorizationVerifyingTips;
    private LinearLayout llDetailTips;
    private TextView tvDetailInformationTips;
    private final String tipsSuffix = " \u8be6\u7ec6\u5185\u5bb9";
    private String clientId;
    private String userIdentifier;
    private boolean hasAuthRecord;
    private final IdentifyModel identifyModel = new IdentifyModel();
    private Subscription identificationCheckSubscription;
    private IdentificationInfo userEditIdentificationInfo;
    private boolean isIdentificationInfoVerifying = false;
    private RealNameResultCallback realNameResultCallback;

    public static DialogGameRealName getInstance(String clientId, String userIdentifier, boolean hasAuthRecord, RealNameResultCallback callback) {
        DialogGameRealName dialog = new DialogGameRealName();
        Bundle bundle = new Bundle();
        bundle.putString("client_id", clientId);
        bundle.putString("user_identifier", userIdentifier);
        bundle.putBoolean("key_has_auth_record", hasAuthRecord);
        dialog.setArguments(bundle);
        dialog.realNameResultCallback = callback;
        return dialog;
    }

    @Override
    public int layoutResId() {
        return R.layout.antiaddictionui_dialog_game_real_name;
    }

    @Override
    public void initView(View contentView) {
        Prompt prompt;
        View vTitleBar = contentView.findViewById(R.id.include_title_bar);
        this.tvTitle = (TextView)vTitleBar.findViewById(R.id.tv_title);
        this.ivClose = (ImageView)vTitleBar.findViewById(R.id.iv_close);
        this.tvRealNameTips = (TextView)contentView.findViewById(R.id.tv_real_name_tips);
        this.etUserRealName = (EditText)contentView.findViewById(R.id.et_user_real_name);
        this.etUserIdentification = (EditText)contentView.findViewById(R.id.et_user_identification);
        this.tvFunctionButton = (TextView)contentView.findViewById(R.id.tv_function_button);
        this.tvUserAuthorizationVerifyingTips = (TextView)contentView.findViewById(R.id.tv_user_authorization_verifying_tips);
        this.llDetailTips = (LinearLayout)contentView.findViewById(R.id.ll_detail_tips);
        this.tvDetailInformationTips = (TextView)contentView.findViewById(R.id.tv_detail_information_tips);
        Prompt prompt2 = prompt = this.hasAuthRecord ? UIConfigHelper.INSTANCE.hasAuthRecordTipsPrompt : UIConfigHelper.INSTANCE.gameRealNameTipsPrompt;
        if (prompt != null) {
            this.tvTitle.setText((CharSequence)prompt.title);
            Spanned tipsText = Html.fromHtml((String)prompt.description);
            this.tvRealNameTips.setText((CharSequence)tipsText);
            this.tvDetailInformationTips.setText((CharSequence)tipsText);
            this.tvFunctionButton.setText((CharSequence)prompt.positiveButton);
        }
        if (!this.hasAuthRecord) {
            this.tvRealNameTips.post(new Runnable(){

                @Override
                public void run() {
                    if (DialogGameRealName.this.tvRealNameTips.getLineCount() > 3) {
                        Layout layout2 = DialogGameRealName.this.tvRealNameTips.getLayout();
                        int lineEndIndex = layout2.getLineEnd(2) - " \u8be6\u7ec6\u5185\u5bb9".length() - 3;
                        String showText = DialogGameRealName.this.tvRealNameTips.getText().toString().substring(0, lineEndIndex) + "..." + " \u8be6\u7ec6\u5185\u5bb9";
                        SpannableString ss = new SpannableString((CharSequence)showText);
                        int startIndex = showText.indexOf(" \u8be6\u7ec6\u5185\u5bb9");
                        ss.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)"#15C5CE")), startIndex, startIndex + " \u8be6\u7ec6\u5185\u5bb9".length(), 33);
                        ss.setSpan((Object)new StyleSpan(1), startIndex, startIndex + " \u8be6\u7ec6\u5185\u5bb9".length(), 33);
                        DialogGameRealName.this.tvRealNameTips.setText((CharSequence)ss);
                    }
                }
            });
        }
        this.ivClose.setVisibility(0);
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.tvRealNameTips.setOnClickListener((View.OnClickListener)this);
        this.tvFunctionButton.setOnClickListener((View.OnClickListener)this);
        this.tvDetailInformationTips.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.etUserIdentification.setRawInputType(2);
    }

    @Override
    public void handleArgumentsData() {
        Bundle args = this.getArguments();
        if (args != null) {
            this.clientId = args.getString("client_id");
            this.userIdentifier = args.getString("user_identifier");
            this.hasAuthRecord = args.getBoolean("key_has_auth_record");
        }
    }

    private Observable<IdentifyState> chooseIdentifyObservable(boolean useStandaloneMode, String clientId, String userIdentifier, String name, String idCard) {
        if (useStandaloneMode) {
            return this.identifyLocalReal(userIdentifier, name, idCard);
        }
        return this.identifyModel.identifyUserManually(clientId, userIdentifier, name, idCard);
    }

    private Observable<IdentifyState> identifyLocalReal(String userIdentifier, String name, String idCard) {
        Activity activity = this.getActivity();
        if (ActivityUtils.isActivityAlive(activity)) {
            return this.identifyModel.identifyUserLocal((Context)activity, userIdentifier, name, idCard);
        }
        return Observable.error((Throwable)new Throwable("unexpected exception"));
    }

    private void identifyUserReal(boolean useStandaloneMode, String clientId, final String userIdentifier, final String name, final String idCard) {
        if (this.identificationCheckSubscription != null && !this.identificationCheckSubscription.isUnsubscribed()) {
            return;
        }
        this.identificationCheckSubscription = this.chooseIdentifyObservable(useStandaloneMode, clientId, userIdentifier, name, idCard).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<IdentifyState>(){

            public void onCompleted() {
            }

            public void onError(final Throwable e) {
                if (e instanceof AntiServerException && ((AntiServerException)e).statusCode >= 500) {
                    AntiAddictionLogger.e((String)"auth service failed");
                    AntiAddictionKit.checkIfStartStandAloneMode((Callback)new Callback<Boolean>(){

                        public void onSuccess(Boolean result) {
                            if (result.booleanValue()) {
                                DialogGameRealName.this.identifyLocalReal(userIdentifier, name, idCard).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Subscriber)new Subscriber<IdentifyState>(){

                                    public void onCompleted() {
                                    }

                                    public void onError(Throwable e) {
                                        ToastUtils.safeToast(DialogGameRealName.this.getActivity(), ToastUtils.fetchErrorMessage(e, "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                                    }

                                    public void onNext(IdentifyState identifyState) {
                                        DialogGameRealName.this.processIdentifyResult(identifyState);
                                    }
                                });
                            } else {
                                ToastUtils.safeToast(DialogGameRealName.this.getActivity(), ToastUtils.fetchErrorMessage(e, "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                            }
                        }

                        public void onError(Throwable throwable) {
                            ToastUtils.safeToast(DialogGameRealName.this.getActivity(), ToastUtils.fetchErrorMessage(e, "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                        }
                    });
                } else if (e instanceof AntiServerException) {
                    ToastUtils.safeToast(DialogGameRealName.this.getActivity(), ToastUtils.fetchErrorMessage(e, "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f"));
                } else {
                    ToastUtils.safeToast(DialogGameRealName.this.getActivity(), ToastUtils.fetchErrorMessage(e, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5"));
                }
            }

            public void onNext(IdentifyState identifyState) {
                DialogGameRealName.this.processIdentifyResult(identifyState);
            }
        });
    }

    private void request2CheckIdentificationInfo() {
        if (this.userEditIdentificationInfo == null) {
            return;
        }
        final String name = this.userEditIdentificationInfo.name;
        final String idCard = this.userEditIdentificationInfo.idCard;
        AntiAddictionKit.checkIfStartStandAloneMode((Callback)new Callback<Boolean>(){

            public void onSuccess(Boolean startSingleAloneMode) {
                DialogGameRealName.this.identifyUserReal(startSingleAloneMode, DialogGameRealName.this.clientId, DialogGameRealName.this.userIdentifier, name, idCard);
            }

            public void onError(Throwable throwable) {
                DialogGameRealName.this.identifyUserReal(false, DialogGameRealName.this.clientId, DialogGameRealName.this.userIdentifier, name, idCard);
            }
        });
    }

    private void processIdentifyResult(IdentifyState identifyState) {
        if (identifyState == null) {
            this.isIdentificationInfoVerifying = false;
            ToastUtils.safeToast(this.getActivity(), "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f");
            return;
        }
        if (identifyState.identifyState == 0) {
            ToastUtils.safeToast(this.getActivity(), "\u63d0\u4ea4\u6210\u529f");
            if (this.realNameResultCallback != null) {
                this.realNameResultCallback.onRealNameSuccess(identifyState);
            }
            this.dismissAllowingStateLoss();
        } else if (identifyState.identifyState == 1) {
            this.isIdentificationInfoVerifying = true;
            this.tvUserAuthorizationVerifyingTips.setVisibility(0);
            this.tvRealNameTips.setVisibility(8);
            this.etUserRealName.setVisibility(8);
            this.etUserIdentification.setVisibility(8);
            Prompt prompt = UIConfigHelper.INSTANCE.duringCertificationPrompt;
            if (prompt != null) {
                this.tvUserAuthorizationVerifyingTips.setText((CharSequence)Html.fromHtml((String)prompt.description));
                this.tvFunctionButton.setText((CharSequence)prompt.positiveButton);
            }
        } else {
            this.isIdentificationInfoVerifying = false;
            ToastUtils.safeToast(this.getActivity(), "\u8ba4\u8bc1\u672a\u901a\u8fc7\uff0c\u8bf7\u63d0\u4ea4\u771f\u5b9e\u4fe1\u606f");
        }
    }

    private boolean checkIdentificationInfo() {
        String name = this.etUserRealName.getEditableText().toString();
        if (TextUtils.isEmpty((CharSequence)name)) {
            ToastUtils.safeToast(this.getActivity(), "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        String identificationNumber = this.etUserIdentification.getEditableText().toString();
        if (TextUtils.isEmpty((CharSequence)identificationNumber)) {
            ToastUtils.safeToast(this.getActivity(), "\u8eab\u4efd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (this.userEditIdentificationInfo == null) {
            this.userEditIdentificationInfo = new IdentificationInfo();
        }
        this.userEditIdentificationInfo.name = name;
        this.userEditIdentificationInfo.idCard = identificationNumber;
        return true;
    }

    private boolean isDetailTipsShowing() {
        if (this.llDetailTips.getVisibility() == 0) {
            this.llDetailTips.setVisibility(8);
            return true;
        }
        return false;
    }

    public void onClick(View v) {
        if (this.isDetailTipsShowing()) {
            return;
        }
        int viewId = v.getId();
        if (viewId == R.id.iv_close) {
            if (this.realNameResultCallback != null) {
                this.realNameResultCallback.onCloseRealName();
            }
            this.dismissAllowingStateLoss();
        } else if (viewId == R.id.tv_real_name_tips) {
            if (!this.hasAuthRecord) {
                this.llDetailTips.setVisibility(0);
            }
        } else if (viewId == R.id.tv_function_button) {
            if (!this.isIdentificationInfoVerifying) {
                if (this.checkIdentificationInfo()) {
                    this.request2CheckIdentificationInfo();
                }
            } else {
                this.dismissAllowingStateLoss();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.identificationCheckSubscription != null) {
            this.identificationCheckSubscription.unsubscribe();
        }
    }

    public static interface RealNameResultCallback {
        public void onRealNameSuccess(IdentifyState var1);

        public void onCloseRealName();
    }
}

