/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.reactor.exceptions;

import com.tapsdk.antiaddiction.reactor.Observer;
import com.tapsdk.antiaddiction.reactor.exceptions.CompositeException;
import com.tapsdk.antiaddiction.reactor.exceptions.OnCompletedFailedException;
import com.tapsdk.antiaddiction.reactor.exceptions.OnErrorFailedException;
import com.tapsdk.antiaddiction.reactor.exceptions.OnErrorNotImplementedException;
import com.tapsdk.antiaddiction.reactor.exceptions.OnErrorThrowable;
import java.util.HashSet;
import java.util.List;

public final class Exceptions {
    private static final int MAX_DEPTH = 25;

    private Exceptions() {
        throw new IllegalStateException("No instances!");
    }

    public static void throwIfFatal(Throwable t) {
        if (t instanceof OnErrorNotImplementedException) {
            throw (OnErrorNotImplementedException)t;
        }
        if (t instanceof OnErrorFailedException) {
            throw (OnErrorFailedException)t;
        }
        if (t instanceof OnCompletedFailedException) {
            throw (OnCompletedFailedException)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    public static void addCause(Throwable e, Throwable cause) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return;
            }
            if (seenCauses.contains((e = e.getCause()).getCause())) break;
            seenCauses.add(e.getCause());
        }
        try {
            e.initCause(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void throwIfAny(List<? extends Throwable> exceptions) {
        if (exceptions != null && !exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                Throwable t = exceptions.get(0);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            throw new CompositeException(exceptions);
        }
    }

    public static Throwable getFinalCause(Throwable e) {
        int i = 0;
        while (e.getCause() != null) {
            if (i++ >= 25) {
                return new RuntimeException("Stack too deep to get final cause");
            }
            e = e.getCause();
        }
        return e;
    }

    public static void throwOrReport(Throwable t, Observer<?> o, Object value) {
        Exceptions.throwIfFatal(t);
        o.onError(OnErrorThrowable.addValueAsLastCause(t, value));
    }

    public static void throwOrReport(Throwable t, Observer<?> o) {
        Exceptions.throwIfFatal(t);
        o.onError(t);
    }
}

