/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.reactor.operators;

import com.tapsdk.antiaddiction.reactor.Observer;
import java.io.Serializable;

public final class NotificationLite {
    private static final Object ON_COMPLETED_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 1L;

        public String toString() {
            return "Notification=>Completed";
        }
    };
    private static final Object ON_NEXT_NULL_SENTINEL = new Serializable(){
        private static final long serialVersionUID = 2L;

        public String toString() {
            return "Notification=>NULL";
        }
    };

    private NotificationLite() {
    }

    public static <T> Object next(T t) {
        if (t == null) {
            return ON_NEXT_NULL_SENTINEL;
        }
        return t;
    }

    public static Object completed() {
        return ON_COMPLETED_SENTINEL;
    }

    public static Object error(Throwable e) {
        return new OnErrorSentinel(e);
    }

    public static <T> boolean accept(Observer<? super T> o, Object n) {
        if (n == ON_COMPLETED_SENTINEL) {
            o.onCompleted();
            return true;
        }
        if (n == ON_NEXT_NULL_SENTINEL) {
            o.onNext(null);
            return false;
        }
        if (n != null) {
            if (n.getClass() == OnErrorSentinel.class) {
                o.onError(((OnErrorSentinel)n).e);
                return true;
            }
            o.onNext(n);
            return false;
        }
        throw new IllegalArgumentException("The lite notification can not be null");
    }

    public static boolean isCompleted(Object n) {
        return n == ON_COMPLETED_SENTINEL;
    }

    public static boolean isError(Object n) {
        return n instanceof OnErrorSentinel;
    }

    public static boolean isNull(Object n) {
        return n == ON_NEXT_NULL_SENTINEL;
    }

    public static boolean isNext(Object n) {
        return n != null && !NotificationLite.isError(n) && !NotificationLite.isCompleted(n);
    }

    public static <T> T getValue(Object n) {
        return (T)(n == ON_NEXT_NULL_SENTINEL ? null : n);
    }

    public static Throwable getError(Object n) {
        return ((OnErrorSentinel)n).e;
    }

    static final class OnErrorSentinel
    implements Serializable {
        private static final long serialVersionUID = 3L;
        final Throwable e;

        public OnErrorSentinel(Throwable e) {
            this.e = e;
        }

        public String toString() {
            return "Notification=>Error:" + this.e;
        }
    }
}

