/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.websocket.conn;

import com.tds.common.websocket.conn.WebSocket;
import com.tds.common.websocket.conn.WebSocketListener;
import com.tds.common.websocket.drafts.Draft;
import com.tds.common.websocket.exceptions.InvalidDataException;
import com.tds.common.websocket.framing.Framedata;
import com.tds.common.websocket.framing.PingFrame;
import com.tds.common.websocket.framing.PongFrame;
import com.tds.common.websocket.handshake.ClientHandshake;
import com.tds.common.websocket.handshake.HandshakeImpl1Server;
import com.tds.common.websocket.handshake.ServerHandshake;
import com.tds.common.websocket.handshake.ServerHandshakeBuilder;

public abstract class WebSocketAdapter
implements WebSocketListener {
    private PingFrame pingFrame;

    @Override
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket conn, Draft draft, ClientHandshake request) throws InvalidDataException {
        return new HandshakeImpl1Server();
    }

    @Override
    public void onWebsocketHandshakeReceivedAsClient(WebSocket conn, ClientHandshake request, ServerHandshake response) throws InvalidDataException {
    }

    @Override
    public void onWebsocketHandshakeSentAsClient(WebSocket conn, ClientHandshake request) throws InvalidDataException {
    }

    @Override
    public void onWebsocketPing(WebSocket conn, Framedata f) {
        conn.sendFrame(new PongFrame((PingFrame)f));
    }

    @Override
    public void onWebsocketPong(WebSocket conn, Framedata f) {
    }

    @Override
    public PingFrame onPreparePing(WebSocket conn) {
        if (this.pingFrame == null) {
            this.pingFrame = new PingFrame();
        }
        return this.pingFrame;
    }
}

