/*
 * Decompiled with CFR 0.152.
 */
package tds.androidx.core.view;

import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsController;
import tds.androidx.annotation.IdRes;
import tds.androidx.annotation.NonNull;
import tds.androidx.annotation.Nullable;
import tds.androidx.annotation.RequiresApi;
import tds.androidx.core.view.WindowInsetsControllerCompat;

public final class WindowCompat {
    public static final int FEATURE_ACTION_BAR = 8;
    public static final int FEATURE_ACTION_BAR_OVERLAY = 9;
    public static final int FEATURE_ACTION_MODE_OVERLAY = 10;

    private WindowCompat() {
    }

    @NonNull
    public static <T extends View> T requireViewById(@NonNull Window window, @IdRes int id2) {
        if (Build.VERSION.SDK_INT >= 28) {
            return (T)window.requireViewById(id2);
        }
        View view = window.findViewById(id2);
        if (view == null) {
            throw new IllegalArgumentException("ID does not reference a View inside this Window");
        }
        return (T)view;
    }

    public static void setDecorFitsSystemWindows(@NonNull Window window, boolean decorFitsSystemWindows) {
        if (Build.VERSION.SDK_INT >= 30) {
            Impl30.setDecorFitsSystemWindows(window, decorFitsSystemWindows);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Impl16.setDecorFitsSystemWindows(window, decorFitsSystemWindows);
        }
    }

    @Nullable
    public static WindowInsetsControllerCompat getInsetsController(@NonNull Window window, @NonNull View view) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Impl30.getInsetsController(window);
        }
        return new WindowInsetsControllerCompat(window, view);
    }

    @RequiresApi(value=30)
    private static class Impl30 {
        private Impl30() {
        }

        static void setDecorFitsSystemWindows(@NonNull Window window, boolean decorFitsSystemWindows) {
            window.setDecorFitsSystemWindows(decorFitsSystemWindows);
        }

        static WindowInsetsControllerCompat getInsetsController(@NonNull Window window) {
            WindowInsetsController insetsController = window.getInsetsController();
            if (insetsController != null) {
                return WindowInsetsControllerCompat.toWindowInsetsControllerCompat(insetsController);
            }
            return null;
        }
    }

    @RequiresApi(value=16)
    private static class Impl16 {
        private Impl16() {
        }

        static void setDecorFitsSystemWindows(@NonNull Window window, boolean decorFitsSystemWindows) {
            int decorFitsFlags = 1792;
            View decorView = window.getDecorView();
            int sysUiVis = decorView.getSystemUiVisibility();
            decorView.setSystemUiVisibility(decorFitsSystemWindows ? sysUiVis & 0xFFFFF8FF : sysUiVis | 0x700);
        }
    }
}

