/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.dialog.news.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LevelListDrawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sdk.douyou.Constant;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.util.LogUtil;
import com.sdk.douyou.util.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class NoticeFragment
extends Fragment {
    private int page = 1;
    private Activity activity;
    private RelativeLayout douyou_ball_notice_ly;
    private ImageView douyou_hongbao_login_notice_img;
    private TextView douyou_hongbao_login_notice_tv;
    private TextView douyou_login_notice_title;
    private int intwidth;
    private int intheight;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.activity = this.getActivity();
        View v = LayoutInflater.from((Context)this.getActivity()).inflate(ResourceUtil.getLayoutId((Context)this.getActivity(), "douyou_pay_notice_dialog"), null);
        this.douyou_ball_notice_ly = (RelativeLayout)v.findViewById(ResourceUtil.getId((Context)this.getActivity(), "douyou_ball_notice_ly"));
        this.douyou_ball_notice_ly.setBackground(this.activity.getDrawable(ResourceUtil.getDrawableId((Context)this.activity, "douyou_ball_head")));
        this.douyou_hongbao_login_notice_img = (ImageView)v.findViewById(ResourceUtil.getId((Context)this.getActivity(), "douyou_hongbao_login_notice_img"));
        this.douyou_hongbao_login_notice_img.setVisibility(8);
        if (DouYou.getInstance().context.getResources().getConfiguration().orientation == 2) {
            this.intwidth = DouYou.getInstance().context.getResources().getDisplayMetrics().widthPixels / 6 * 3 - 20;
            this.intheight = (int)((double)(DouYou.getInstance().context.getResources().getDisplayMetrics().heightPixels / 3) * 2.6);
        } else {
            this.intwidth = (int)((double)(DouYou.getInstance().context.getResources().getDisplayMetrics().widthPixels / 3) * 2.5 - 20.0);
            this.intheight = (int)((double)(DouYou.getInstance().context.getResources().getDisplayMetrics().heightPixels / 3) * 1.5);
        }
        this.douyou_hongbao_login_notice_tv = (TextView)v.findViewById(ResourceUtil.getId((Context)DouYou.getInstance().context, "douyou_hongbao_login_notice_tv"));
        if (!TextUtils.isEmpty((CharSequence)Constant.douyou_notice_content)) {
            HtmlImageGetter htmlImageGetter = new HtmlImageGetter();
            Spanned spanned = Html.fromHtml((String)Constant.douyou_notice_content, (Html.ImageGetter)htmlImageGetter, null);
            this.douyou_hongbao_login_notice_tv.setText((CharSequence)spanned);
        } else {
            this.douyou_hongbao_login_notice_tv.setText((CharSequence)"\u6682\u65e0\u516c\u544a");
        }
        this.douyou_hongbao_login_notice_tv.setMovementMethod(ScrollingMovementMethod.getInstance());
        this.douyou_login_notice_title = (TextView)v.findViewById(ResourceUtil.getId((Context)this.getActivity(), "douyou_login_notice_title"));
        if (!TextUtils.isEmpty((CharSequence)Constant.douyou_notice_title)) {
            this.douyou_login_notice_title.setText((CharSequence)Constant.douyou_notice_title);
        }
        return v;
    }

    class HtmlImageGetter
    implements Html.ImageGetter {
        HtmlImageGetter() {
        }

        public Drawable getDrawable(String source) {
            LevelListDrawable d = new LevelListDrawable();
            Drawable empty = DouYou.getInstance().context.getResources().getDrawable(ResourceUtil.getDrawableId((Context)DouYou.getInstance().context, "ic_loading_white_01"));
            d.addLevel(0, 0, empty);
            d.setBounds(0, 0, NoticeFragment.this.intwidth, empty.getIntrinsicHeight());
            new LoadImage().execute(new Object[]{source, d});
            return d;
        }

        class LoadImage
        extends AsyncTask<Object, Void, Bitmap> {
            private LevelListDrawable mDrawable;

            LoadImage() {
            }

            protected Bitmap doInBackground(Object ... params) {
                String source = (String)params[0];
                this.mDrawable = (LevelListDrawable)params[1];
                try {
                    InputStream is = new URL(source).openStream();
                    return BitmapFactory.decodeStream((InputStream)is);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            protected void onPostExecute(Bitmap bitmap) {
                if (bitmap != null) {
                    BitmapDrawable d = new BitmapDrawable(bitmap);
                    this.mDrawable.addLevel(1, 1, (Drawable)d);
                    this.mDrawable = this.getDrawableAdapter((Context)DouYou.getInstance().context, this.mDrawable, bitmap.getWidth(), bitmap.getHeight());
                    this.mDrawable.setLevel(1);
                    NoticeFragment.this.douyou_hongbao_login_notice_tv.invalidate();
                    CharSequence t = NoticeFragment.this.douyou_hongbao_login_notice_tv.getText();
                    NoticeFragment.this.douyou_hongbao_login_notice_tv.setText(t);
                    LogUtil.debug("mtextView_content:" + NoticeFragment.this.douyou_hongbao_login_notice_tv.getText());
                }
            }

            public LevelListDrawable getDrawableAdapter(Context context, LevelListDrawable drawable, int oldWidth, int oldHeight) {
                LevelListDrawable newDrawable = drawable;
                long newHeight = 0L;
                int newWidth = 0;
                if (oldWidth > NoticeFragment.this.intwidth) {
                    newWidth = NoticeFragment.this.intwidth;
                    newHeight = newWidth * oldHeight / oldWidth;
                } else {
                    newWidth = oldWidth;
                    newHeight = oldHeight;
                }
                newDrawable.setBounds(0, 0, newWidth, (int)newHeight);
                return newDrawable;
            }
        }
    }
}

