/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.account;

import com.tds.common.account.TdsAccount;
import org.json.JSONException;
import org.json.JSONObject;

public class TapAccount
implements TdsAccount<JSONObject> {
    private JSONObject accessToken;
    private String tokenString;
    public String kid;
    public String access_token;
    public String token_type;
    public String mac_key;
    public String mac_algorithm;

    public TapAccount(String tapToken) {
        try {
            this.tokenString = tapToken;
            this.accessToken = new JSONObject(tapToken);
            this.kid = this.accessToken.optString("kid");
            this.access_token = this.accessToken.optString("access_token");
            this.token_type = this.accessToken.optString("token_type");
            this.mac_key = this.accessToken.optString("mac_key");
            this.mac_algorithm = this.accessToken.optString("mac_algorithm");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public TdsAccount.AccountType getAccountType() {
        return TdsAccount.AccountType.TAP;
    }

    @Override
    public JSONObject getToken() {
        return this.accessToken;
    }

    public String getTokenString() {
        return this.tokenString;
    }
}

