/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.entities;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class AccessToken
implements Parcelable {
    public static final String ROOT_ELEMENT_NAME = "data";
    public final String accessToken;
    public final String kid;
    public final String tokenType;
    public final String macKey;
    public final String macAlgorithm;
    public final String expireIn;
    public final String originalJson;
    public static final Parcelable.Creator<AccessToken> CREATOR = new Parcelable.Creator<AccessToken>(){

        public AccessToken createFromParcel(Parcel source) {
            return new AccessToken(source);
        }

        public AccessToken[] newArray(int size) {
            return new AccessToken[size];
        }
    };

    public AccessToken(JSONObject jsonObject) {
        this.accessToken = jsonObject.optString("access_token");
        this.kid = jsonObject.optString("kid");
        this.tokenType = jsonObject.optString("token_type");
        this.macKey = jsonObject.optString("mac_key");
        this.macAlgorithm = jsonObject.optString("mac_algorithm");
        this.expireIn = jsonObject.optString("expire_in", "0");
        this.originalJson = jsonObject.toString();
    }

    public AccessToken(JSONObject accessTokenJsonObject, boolean fromRoot) {
        JSONObject data = accessTokenJsonObject.optJSONObject(ROOT_ELEMENT_NAME);
        if (data != null) {
            this.originalJson = data.toString();
            this.accessToken = data.optString("access_token");
            this.kid = data.optString("kid");
            this.tokenType = data.optString("token_type");
            this.macKey = data.optString("mac_key");
            this.macAlgorithm = data.optString("mac_algorithm");
            this.expireIn = data.optString("expire_in", "0");
        } else {
            this.originalJson = "";
            this.accessToken = "";
            this.kid = "";
            this.tokenType = "";
            this.macKey = "";
            this.macAlgorithm = "";
            this.expireIn = "";
        }
    }

    private AccessToken() {
        this.accessToken = "";
        this.kid = "";
        this.tokenType = "";
        this.macKey = "";
        this.macAlgorithm = "";
        this.expireIn = "0";
        this.originalJson = "";
    }

    public AccessToken(String sessionToken) {
        this.accessToken = sessionToken;
        this.kid = "";
        this.tokenType = "";
        this.macKey = "";
        this.macAlgorithm = "";
        this.expireIn = "0";
        this.originalJson = "";
    }

    public String toJSON() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("access_token", (Object)this.accessToken);
            jsonObject.put("kid", (Object)this.kid);
            jsonObject.put("token_type", (Object)this.tokenType);
            jsonObject.put("mac_key", (Object)this.macKey);
            jsonObject.put("mac_algorithm", (Object)this.macAlgorithm);
            jsonObject.put("expire_in", (Object)this.expireIn);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    public String toString() {
        return "AccessToken{accessToken='" + this.accessToken + '\'' + ", kid='" + this.kid + '\'' + ", tokenType='" + this.tokenType + '\'' + ", macKey='" + this.macKey + '\'' + ", macAlgorithm='" + this.macAlgorithm + '\'' + ", expireIn='" + this.expireIn + '\'' + ", originalJson='" + this.originalJson + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    protected AccessToken(Parcel in) {
        this.accessToken = in.readString();
        this.kid = in.readString();
        this.tokenType = in.readString();
        this.macKey = in.readString();
        this.macAlgorithm = in.readString();
        this.expireIn = in.readString();
        this.originalJson = in.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.accessToken);
        dest.writeString(this.kid);
        dest.writeString(this.tokenType);
        dest.writeString(this.macKey);
        dest.writeString(this.macAlgorithm);
        dest.writeString(this.expireIn);
        dest.writeString(this.originalJson);
    }
}

