/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.localize;

import com.tds.common.localize.LocalizeManager;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalizeStore {
    private final HashMap<Integer, JSONObject> langDictSparseArray = new HashMap();
    private int preferredLang = 0;
    private boolean isDomestic;

    private LocalizeStore() {
    }

    void setPreferredLang(int lang) {
        this.preferredLang = lang;
    }

    public LocalizeStore(JSONObject dict, boolean domestic) {
        for (Map.Entry<String, Integer> entry : LocalizeManager.supportedLangMap.entrySet()) {
            try {
                this.langDictSparseArray.put(entry.getValue(), dict.getJSONObject(entry.getKey()));
            }
            catch (JSONException jsonException) {
                System.out.println("" + entry.getKey() + " multi-language Not config");
            }
        }
        this.isDomestic = domestic;
    }

    public String getStringValue(String resId) {
        try {
            int lang = this.preferredLang;
            JSONObject dict = this.langDictSparseArray.get(lang);
            if (dict == null) {
                int n = lang = this.isDomestic ? 1 : 2;
            }
            if ((dict = this.langDictSparseArray.get(lang)) == null) {
                return "";
            }
            return dict.getString(resId);
        }
        catch (Exception jsonException) {
            return "";
        }
    }
}

